import React, { useState } from 'react';
import './Auth.css';
import image from './logo.svg'; // 引入图片
const Login = ({ onRegisterClick }) => {
  const [formData, setFormData] = useState({
    username: '',
    password: ''
  });

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData(prev => ({ ...prev, [name]: value }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    try {
      const response = await fetch('http://localhost:8080/user/login', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(formData),
      });
  
      const result = await response.json();
      if (response.ok && result.code === "0") {
        console.log('登录成功:', result);
        // 处理成功逻辑
      } else {
        console.error('登录失败:', result);
        // 处理失败逻辑
      }
    } catch (error) {
      console.error('请求错误:', error);
      // 处理请求错误
    }
  };

  return (
    <div className="auth-container">
      <img 
        src={image} 
        alt="描述" 
        style={{ width: '30%', height: 'auto'}} 
      />
      <div className="auth-form-section">
        {/* <h3>欢迎来到EchoTorent !</h3> */}
        <h3>用户登录</h3>
        <form onSubmit={handleSubmit}>
          <div className="form-group">
            <label>用户名</label>
            <input
              type="text"
              name="username"
              placeholder="请输入用户名"
              value={formData.username}
              onChange={handleChange}
              className="form-input"
            />
          </div>
          <div className="form-group">
            <label>密码</label>
            <input
              type="password"
              name="password"
              placeholder="请输入密码"
              value={formData.password}
              onChange={handleChange}
              className="form-input"
            />
            <button 
              type="button" 
              className="link-button forgot-password" 
              onClick={() => console.log('跳转到忘记密码页面')}
            >
              忘记密码？
            </button>
          </div>
          <button type="submit" className="auth-button">
            登录
          </button>
          <p className="register-link">
            没有账号? 
            <button onClick={onRegisterClick} className="link-button">
               点击注册
            </button>
          </p>
        </form>
      </div>
    </div>
  );
};

export default Login;