import React from 'react';
import { render, screen, fireEvent } from '@testing-library/react';
import Login from './Login';

describe('Login component', () => {
  test('renders login form', () => {
    const onRegisterClick = jest.fn();
    render(<Login onRegisterClick={onRegisterClick} />);

    const usernameInput = screen.getByPlaceholderText('请输入用户名');
    const passwordInput = screen.getByPlaceholderText('请输入密码');
    const loginButton = screen.getByText('登录');

    expect(usernameInput).toBeInTheDocument();
    expect(passwordInput).toBeInTheDocument();
    expect(loginButton).toBeInTheDocument();
  });

  test('calls onRegisterClick when "点击注册" is clicked', () => {
    const onRegisterClick = jest.fn();
    render(<Login onRegisterClick={onRegisterClick} />);

    const registerButton = screen.getByText('点击注册');
    fireEvent.click(registerButton);

    expect(onRegisterClick).toHaveBeenCalled();
  });
});