import React from 'react';
import { render, screen, fireEvent } from '@testing-library/react';
import Register from './Register';

describe('Register component', () => {
  test('renders register form', () => {
    const onLoginClick = jest.fn();
    render(<Register onLoginClick={onLoginClick} />);

    const usernameInput = screen.getByPlaceholderText('请输入用户名');
    const passwordInput = screen.getByPlaceholderText('请输入密码');
    const emailInput = screen.getByPlaceholderText('请输入邮箱');
    const verifyButton = screen.getByText('验证邮箱');
    const registerButton = screen.getByText('注册');

    expect(usernameInput).toBeInTheDocument();
    expect(passwordInput).toBeInTheDocument();
    expect(emailInput).toBeInTheDocument();
    expect(verifyButton).toBeInTheDocument();
    expect(registerButton).toBeInTheDocument();
  });

  test('calls onLoginClick when "点击登录" is clicked', () => {
    const onLoginClick = jest.fn();
    render(<Register onLoginClick={onLoginClick} />);

    const loginButton = screen.getByText('点击登录');
    fireEvent.click(loginButton);

    expect(onLoginClick).toHaveBeenCalled();
  });
});