// import { Route } from 'wouter';
// import { Redirect } from 'wouter';
// import AuthPage from './pages/AuthPage/AuthPage';
// import HomePage from './pages/HomePage';
// import FriendMoments from './pages/FriendMoments/FriendMoments';
// import ForumPage from './pages/Forum/posts-main/ForumPage';
// import SeedList from './pages/SeedList/SeedList';
// import PostDetailPage from './pages/Forum/posts-detail/PostDetailPage';
// import { UserProvider } from './context/UserContext';
// import { GroupProvider } from './context/useGroupStore'; // 导入 GroupProvider
// import PublishSeed from './pages/PublishSeed/PublishSeed';
// import SeedDetail from './pages/SeedList/SeedDetail/SeedDetail';
// import InterestGroup from './pages/InterestGroup/InterestGroup';
// import UserProfile from './pages/UserCenter/UserProfile';
// import CreatePostPage from './pages/Forum/posts-create/CreatePostPage';
// import MessagePage from './pages/MessagePage/MessagePage';
// import CreateMoment from './pages/FriendMoments/CreateMoment';
// import PromotionsPage from './pages/PromotionsPage/PromotionsPage';
// import LevelPage from './pages/LevelPage/LevelPage';
// import NewbieTasks from './pages/UserCenter/NewbieTasks';
// // import UserDynamics from './pages/UserCenter/UserDynamics';
// import UserFriends from './pages/UserCenter/UserFriends';
// import UserCollect from './pages/UserCenter/UserCollect';
// import UserInvite from './pages/UserCenter/UserInvite';
// import SimpleUploader from './pages/PublishSeed/SimpleUploader';

// function RedirectToAuth() {
//   if (typeof window !== 'undefined') {
//     window.location.replace('/auth');
//   }
//   return null;
// }

// function App() {
//   return (
//     <UserProvider>
//       <GroupProvider> {/* 添加 GroupProvider */}
//         <>
//           <Route path="/" component={RedirectToAuth} />
//           <Route path="/auth" component={AuthPage} />
//           <Route path="/friend-moments" component={FriendMoments} />
//           <Route path="/friend-moments/create" component={CreateMoment} />
//           <Route path="/forum" component={ForumPage} />
//           <Route path="/forum/post/:postId" component={PostDetailPage} />
//           <Route path="/forum/create-post" component={CreatePostPage} />
//           <Route path="/seed-list" component={SeedList} />
//           {/* <Route path="/publish-seed" component={PublishSeed} /> */}
//           <Route path="/publish-seed" component={SimpleUploader} />
//           <Route path="/seed/:seed_id" component={SeedDetail} />
//           <Route path="/interest-groups" component={InterestGroup} />
//           <Route path="/user/profile" component={UserProfile} />
//           <Route path="/messages" component={MessagePage} />
//           <Route path="/promotions" component={PromotionsPage} />
//           <Route path="/level" component={LevelPage} />
//           <Route path="/user/newbie-tasks" component={NewbieTasks} />
//           {/* <Route path="/user/dynamics" component={UserDynamics} /> */}
//           <Route path="/user/friends" component={UserFriends} />
//           <Route path="/user/collections" component={UserCollect} />
//           <Route path="/user/invite" component={UserInvite} />
//         </>
//       </GroupProvider>
//     </UserProvider>
//   );
// }

// export default App;

import { Route } from 'wouter';
import { Redirect } from 'wouter';
import AuthPage from './pages/AuthPage/AuthPage';
import HomePage from './pages/HomePage';
import FriendMoments from './pages/FriendMoments/FriendMoments';
import ForumPage from './pages/Forum/posts-main/ForumPage';
import SeedList from './pages/SeedList/SeedList';
import PostDetailPage from './pages/Forum/posts-detail/PostDetailPage';
import { UserProvider } from './context/UserContext';
import { GroupProvider } from './context/useGroupStore';
import PublishSeed from './pages/PublishSeed/PublishSeed';
import SeedDetail from './pages/SeedList/SeedDetail/SeedDetail';
import InterestGroup from './pages/InterestGroup/InterestGroup';
import UserProfile from './pages/UserCenter/UserProfile';
import CreatePostPage from './pages/Forum/posts-create/CreatePostPage';
import MessagePage from './pages/MessagePage/MessagePage';
import CreateMoment from './pages/FriendMoments/CreateMoment';
import PromotionsPage from './pages/PromotionsPage/PromotionsPage';
import LevelPage from './pages/LevelPage/LevelPage';
import NewbieTasks from './pages/UserCenter/NewbieTasks';
// import UserDynamics from './pages/UserCenter/UserDynamics';
import UserFriends from './pages/UserCenter/UserFriends';
import UserCollect from './pages/UserCenter/UserCollect';
import UserInvite from './pages/UserCenter/UserInvite';
import SimpleUploader from './pages/PublishSeed/SimpleUploader';

import UserLayout from './pages/UserCenter/UserLayout';

function RedirectToAuth() {
  if (typeof window !== 'undefined') {
    window.location.replace('/auth');
  }
  return null;
}

function App() {
  return (
    <UserProvider>
      <GroupProvider>
        <>
          <Route path="/" component={RedirectToAuth} />
          <Route path="/auth" component={AuthPage} />
          <Route path="/friend-moments" component={FriendMoments} />
          <Route path="/friend-moments/create" component={CreateMoment} />
          <Route path="/forum" component={ForumPage} />
          <Route path="/forum/post/:postId" component={PostDetailPage} />
          <Route path="/forum/create-post" component={CreatePostPage} />
          <Route path="/seed-list" component={SeedList} />
          <Route path="/publish-seed" component={SimpleUploader} />
          <Route path="/seed/:seed_id" component={SeedDetail} />
          <Route path="/interest-groups" component={InterestGroup} />
          <Route path="/messages" component={MessagePage} />
          <Route path="/promotions" component={PromotionsPage} />
          <Route path="/level" component={LevelPage} />

          {/* 用户中心嵌套路由模拟 */}
          <Route path="/user/profile" component={() => (
            <UserLayout><UserProfile /></UserLayout>
          )} />
          <Route path="/user/newbie-tasks" component={() => (
            <UserLayout><NewbieTasks /></UserLayout>
          )} />
          {/* <Route path="/user/dynamics" component={() => (
            <UserLayout><UserDynamics /></UserLayout>
          )} /> */}
          <Route path="/user/friends" component={() => (
            <UserLayout><UserFriends /></UserLayout>
          )} />
          <Route path="/user/collections" component={() => (
            <UserLayout><UserCollect /></UserLayout>
          )} />
          <Route path="/user/invite" component={() => (
            <UserLayout><UserInvite /></UserLayout>
          )} />
        </>
      </GroupProvider>
    </UserProvider>
  );
}

export default App;
