import React, { useState } from 'react';
import axios from 'axios';
import { Edit } from '@icon-park/react';
import './CreatePostButton.css';
import { useUser } from '../../../../context/UserContext';

const user = JSON.parse(localStorage.getItem('user')); // user = { user_id: 123, ... }
const userId = user?.userId;


const CreatePostButton = () => {
  const { user } = useUser();
  const userId = user?.userId;  // 这里改为 userId，跟 UserContext 统一

  const [showModal, setShowModal] = useState(false);
  const [title, setTitle] = useState('');
  const [content, setContent] = useState('');
  const [previewUrls, setPreviewUrls] = useState([]);
  const [files, setFiles] = useState([]);

  const handleImageChange = (e) => {
    const selectedFiles = Array.from(e.target.files);
    if (!selectedFiles.length) return;
    setFiles(selectedFiles);
    setPreviewUrls(selectedFiles.map(f => URL.createObjectURL(f)));
  };

  const handleSubmit = async () => {
    if (!userId) {
      alert('用户未登录或用户ID未获取到，无法发帖');
      return;
    }
    if (!title.trim() || !content.trim()) {
      alert('标题和内容均为必填项');
      return;
    }

    const formData = new FormData();
    formData.append('title', title.trim());
    formData.append('postContent', content.trim());

    files.forEach(file => {
      formData.append('imageUrl', file);
    });

    try {
      await axios.post(
        `/echo/forum/posts/${userId}/createPost`,
        formData,
        {
          headers: { 'Content-Type': 'multipart/form-data' }
        }
      );

      setTitle('');
      setContent('');
      setFiles([]);
      setPreviewUrls([]);
      setShowModal(false);
      alert('发帖成功');
    } catch (err) {
      console.error('发帖失败：', err.response?.data || err);
      alert(err.response?.data?.error || '发帖失败，请稍后重试');
    }
  };

  return (
    <>
      <div className="create-post">
        <button onClick={() => setShowModal(true)} className="create-btn">
          <Edit theme="outline" size="18" style={{ marginRight: 6 }} />
          发帖
        </button>
      </div>

      {showModal && (
        <div className="cp-modal-overlay" onClick={() => setShowModal(false)}>
          <div className="cp-modal-dialog" onClick={e => e.stopPropagation()}>
            <h3>创建新帖子</h3>

            <input
              type="text"
              placeholder="帖子标题"
              value={title}
              onChange={e => setTitle(e.target.value)}
            />

            <textarea
              placeholder="正文内容"
              value={content}
              onChange={e => setContent(e.target.value)}
            />

            <label className="file-label">
              选择图片
              <input
                type="file"
                accept="image/*"
                multiple
                onChange={handleImageChange}
                style={{ display: 'none' }}
              />
            </label>

            <div className="cp-preview">
              {previewUrls.map((url, i) => (
                <img key={i} src={url} alt={`预览 ${i}`} />
              ))}
            </div>

            <div className="cp-actions">
              <button className="btn cancel" onClick={() => setShowModal(false)}>
                取消
              </button>
              <button className="btn submit" onClick={handleSubmit}>
                发布
              </button>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default CreatePostButton;
