import React from 'react';
import { useGroupStore } from '../../context/useGroupStore';

const GroupPagination = () => {
  const { page, totalPages, setPage } = useGroupStore();

  const handlePrevPage = () => {
    if (page > 1) setPage(page - 1);
  };

  const handleNextPage = () => {
    if (page < totalPages) setPage(page + 1);
  };

  return (
    <div className="pagination">
      <button onClick={handlePrevPage} disabled={page <= 1}>
        上一页
      </button>
      <span>第 {page} 页 / 共 {totalPages} 页</span>
      <button onClick={handleNextPage} disabled={page >= totalPages}>
        下一页
      </button>
    </div>
  );
};

export default GroupPagination;