import React, { useEffect } from 'react';
import Header from '../../components/Header';
import { useGroupStore } from '../../context/useGroupStore';
import GroupFilters from './GroupFilters';
import GroupList from './GroupList';
import GroupPagination from './GroupPagination';
import './InterestGroup.css';
const InterestGroup = () => {
  const { fetchGroupList, setPage, handleSearch } = useGroupStore();

  // 初始化加载
  useEffect(() => {
    fetchGroupList();
  }, [fetchGroupList]);

  return (
    <div className="interest-group-container">
      <Header />
      <div className="interest-group-card">
        <GroupFilters />
        <GroupList />
        <GroupPagination />
      </div>
    </div>
  );
};

export default InterestGroup;