// import React, { useEffect, useState } from 'react';
// import axios from 'axios';
// import Header from '../../components/Header';
// import UserNav from './UserNav';
// import { useUser } from '../../context/UserContext';
// import { useLocation } from 'wouter';
// import './UserProfile.css'; // ✅ 复用个人资料通用样式

// const UserCollect = () => {
//   const { user, loading: userLoading } = useUser();
//   const [collections, setCollections] = useState([]);
//   const [loading, setLoading] = useState(true);
//   const [error, setError] = useState(null);
//   const [, navigate] = useLocation();

//   useEffect(() => {
//     if (userLoading) return;

//     if (!user || !user.userId) {
//       setError('未登录或用户信息获取失败');
//       setLoading(false);
//       return;
//     }

//     const fetchCollections = async () => {
//       try {
//         const response = await axios.get(`/echo/forum/posts/${user.userId}/getAllcollections`);
//         setCollections(response.data || []);
//         setError(null);
//       } catch (error) {
//         console.error('获取收藏失败:', error);
//         setError('获取收藏失败，请稍后再试');
//       } finally {
//         setLoading(false);
//       }
//     };

//     fetchCollections();
//   }, [user, userLoading]);

//   if (loading || userLoading) {
//     return <p className="loading">加载中...</p>;
//   }

//   return (
//     <div className="user-profile-container">
//       <Header />
//       <div className="user-center">
//         <div className="user-nav-container">
//           <UserNav activeKey="collect" />
//         </div>

//         <div className="common-card right-content">
//           <div className="profile-header">
//             <h1>📌 我的收藏</h1>
//           </div>

//           {error ? (
//             <p className="error-text">{error}</p>
//           ) : collections.length === 0 ? (
//             <p>暂无收藏内容。</p>
//           ) : (
//             <div className="collection-list">
//               {collections.map((post) => (
//                 <div
//                   key={post.postNo}
//                   className="collection-item"
//                   onClick={() => navigate(`/forum/post/${post.postNo}`)}
//                 >
//                   <h3>{post.title || '无标题'}</h3>
//                   <p className="content-preview">
//                     {post.postContent?.slice(0, 100) || '暂无内容'}...
//                   </p>
//                   <p className="meta">
//                     作者：{post.username || '未知'} | 发布时间未知
//                   </p>
//                   <hr />
//                 </div>
//               ))}
//             </div>
//           )}
//         </div>
//       </div>
//     </div>
//   );
// };

// export default UserCollect;

import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { useUser } from '../../context/UserContext';
import { useLocation } from 'wouter';
import './UserCollect.css';

const UserCollect = () => {
  const { user, loading: userLoading } = useUser();
  const [collections, setCollections] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [, navigate] = useLocation();

  useEffect(() => {
    if (userLoading) return;

    if (!user || !user.userId) {
      setError('未登录或用户信息获取失败');
      setLoading(false);
      return;
    }

    const fetchCollections = async () => {
      try {
        const response = await axios.get(`/echo/forum/posts/${user.userId}/getAllcollections`);
        setCollections(response.data || []);
        setError(null);
      } catch (error) {
        console.error('获取收藏失败:', error);
        setError('获取收藏失败，请稍后再试');
      } finally {
        setLoading(false);
      }
    };

    fetchCollections();
  }, [user, userLoading]);

  return (
    <div className="common-card right-content">
      <div className="profile-header">
        <h2>📌 我的收藏</h2>
      </div>

      {userLoading || loading ? (
        <p className="loading-text">加载中...</p>
      ) : error ? (
        <p className="error-text">{error}</p>
      ) : collections.length === 0 ? (
        <p>暂无收藏内容。</p>
      ) : (
        <div className="collection-list">
          {collections.map((post) => (
            <div
              key={post.postNo}
              className="collection-item"
              onClick={() => navigate(`/forum/post/${post.postNo}`)}
            >
              <h3>{post.title || '无标题'}</h3>
              <p className="preview">{post.postContent?.slice(0, 100) || '暂无内容'}...</p>
              <p className="meta">作者：{post.username || '未知'} | 发布时间未知</p>
              <hr />
            </div>
          ))}
        </div>
      )}
    </div>
  );
};

export default UserCollect;

