import { Route } from 'wouter';
import AuthPage from './pages/AuthPage/AuthPage';
import HomePage from './pages/HomePage';
import FriendMoments from './pages/FriendMoments/FriendMoments';
import ForumPage from './pages/Forum/posts-main/ForumPage';
import SeedList from './pages/SeedList/SeedList';
import PostDetailPage from './pages/Forum/posts-detail/PostDetailPage';
import { UserProvider } from './context/UserContext';
import PublishSeed from './pages/PublishSeed/PublishSeed';
import SeedDetail from './pages/SeedList/SeedDetail/SeedDetail'; 
import InterestGroup from './pages/InterestGroup/InterestGroup';
import UserProfile from './pages/UserCenter/UserProfile';
import CreatePostPage from './pages/Forum/posts-create/CreatePostPage';
import MessagePage from './pages/MessagePage/MessagePage';
import CreateMoment from './pages/FriendMoments/CreateMoment';
import PromotionsPage from './pages/PromotionsPage/PromotionsPage';
import LevelPage from './pages/LevelPage/LevelPage';
import NewbieTasks from './pages/UserCenter/NewbieTasks';

function App() {
  return (
    <UserProvider>
      <>
        <Route path="/" component={HomePage} />
        <Route path="/auth" component={AuthPage} />
        <Route path="/friend-moments" component={FriendMoments} />
        <Route path="/friend-moments/create" component={CreateMoment} />
        <Route path="/forum" component={ForumPage} />
        <Route path="/forum/post/:postId" component={PostDetailPage} />
        <Route path="/forum/create-post" component={CreatePostPage} />
        <Route path="/seed-list" component={SeedList} />
        <Route path="/publish-seed" component={PublishSeed} />
        <Route path="/seed/:seed_id" component={SeedDetail} /> {/* 新增路由 */}
        <Route path="/interest-groups" component={InterestGroup}/>
        <Route path="/user/profile" component={UserProfile}/>
        <Route path="/messages" component={MessagePage}/>
        <Route path="/promotions" component={PromotionsPage}/>
        <Route path="/level" component={LevelPage}/>
        <Route path="/user/newbie-tasks" component={NewbieTasks} />
      </>
    </UserProvider>
  );
}

export default App;
