// import React, { useState, useEffect } from 'react';
// import './Header.css'; // 导入 Header.css 文件
// import logo from '../assets/logo.png';

// const Header = () => {
//   const [currentPath, setCurrentPath] = useState(window.location.pathname);

//   // 提取所有页面路径，简化 active 类逻辑
//   const navLinks = [
//     { to: '/friend-moments', label: '好友动态' },
//     { to: '/forum', label: '论坛' },
//     { to: '/interest-groups', label: '兴趣小组' },
//     { to: '/seed-list', label: '种子列表' },
//     { to: '/publish-seed', label: '发布种子' },
//   ];

//   // 更新当前路径状态
//   useEffect(() => {
//     const handleLocationChange = () => {
//       setCurrentPath(window.location.pathname);
//     };

//     // 监听历史记录变化
//     window.addEventListener('popstate', handleLocationChange);

//     // 清理事件监听器
//     return () => {
//       window.removeEventListener('popstate', handleLocationChange);
//     };
//   }, []);

//   // 判断路径是否是当前活动页面
//   const isActive = (path) => currentPath.startsWith(path);

//   // 自定义链接点击逻辑
//   const handleLinkClick = (to) => {
//     window.history.pushState({}, '', to);
//     setCurrentPath(to); // 更新当前路径状态
//   };

//   return (
//     <div className="main-page">
//       {/* 顶部栏 */}
//       <header className="header">
//         {/* 左侧 logo 和网站名称 */}
//         <div className="logo-and-name">
//           <img src={logo} alt="网站 logo" className="logo" />
//           <span className="site-name">Echo</span>
//         </div>
//         {/* 右侧用户头像和消息中心 */}
//         <div className="user-and-message">
//           {/* 用户头像点击跳转到个人主页 */}
//           <a href="/user/profile">
//             <img src="user-avatar.png" alt="用户头像" className="user-avatar" />
//           </a>
//           <span className="message-center">消息</span>
//         </div>
//       </header>

//       {/* 导航栏 */}
//       <nav className="nav">
//         {navLinks.map(({ to, label }) => (
//           <a 
//             key={to} 
//             href={to}
//             onClick={(e) => {
//               e.preventDefault(); // 防止默认跳转行为
//               handleLinkClick(to); // 手动更新当前路径
//             }}
//             className={`nav-item ${isActive(to) ? 'active' : ''}`}
//           >
//             {label}
//           </a>
//         ))}
//       </nav>
//     </div>
//   );
// };

// export default Header;

import React, { useState, useEffect } from 'react';
import './Header.css';
import logo from '../assets/logo.png';

const Header = () => {
  const [currentPath, setCurrentPath] = useState(window.location.pathname);

  const navLinks = [
    { to: '/friend-moments', label: '好友动态' },
    { to: '/forum', label: '论坛' },
    { to: '/interest-groups', label: '兴趣小组' },
    { to: '/seed-list', label: '种子列表' },
    { to: '/publish-seed', label: '发布种子' },
  ];

  useEffect(() => {
    const handleLocationChange = () => {
      setCurrentPath(window.location.pathname);
    };
    window.addEventListener('popstate', handleLocationChange);
    return () => {
      window.removeEventListener('popstate', handleLocationChange);
    };
  }, []);

  const isActive = (path) => currentPath.startsWith(path);

  const handleLinkClick = (to) => {
    window.history.pushState({}, '', to);
    setCurrentPath(to);
  };

  return (
    <div className="main-page">
      <header className="header">
        <div className="logo-and-name">
          <img src={logo} alt="网站 logo" className="logo" />
          <span className="site-name">Echo</span>
        </div>
        <div className="user-and-message">
          <a href="/user/profile">
            <img src="user-avatar.png" alt="用户头像" className="user-avatar" />
          </a>
          {/* 修改这里，点击跳转消息页面 */}
          <span 
            className="message-center" 
            onClick={() => handleLinkClick('/messages')}
            style={{ cursor: 'pointer' }}
          >
            消息
          </span>
        </div>
      </header>

      <nav className="nav">
        {navLinks.map(({ to, label }) => (
          <a 
            key={to} 
            href={to}
            onClick={(e) => {
              e.preventDefault();
              handleLinkClick(to);
            }}
            className={`nav-item ${isActive(to) ? 'active' : ''}`}
          >
            {label}
          </a>
        ))}
      </nav>
    </div>
  );
};

export default Header;
