import React from 'react';

const LevelCard = ({ level, current, next }) => {
  return (
    <div className="border p-4 rounded shadow mb-4 bg-white">
      <h2 className="text-xl font-bold mb-2">当前等级：Lv.{level}</h2>
      <p>当前经验：{current}</p>
      <p>升级所需经验：{next}</p>
      <progress value={current} max={next} className="w-full mt-2" />
    </div>
  );
};

export default LevelCard;
