// import React, { createContext, useContext, useState, useEffect } from 'react';

// const UserContext = createContext();

// export const UserProvider = ({ children }) => {
//   const [user, setUser] = useState(null);
//   const [loading, setLoading] = useState(true);

//   useEffect(() => {
//     const storedUser = localStorage.getItem('user');
//     if (storedUser) {
//       setUser(JSON.parse(storedUser));
//     } else {
//       // 设置默认用户（id: 1）
//       const defaultUser = { id: 1, name: '测试用户' };
//       localStorage.setItem('user', JSON.stringify(defaultUser));
//       setUser(defaultUser);
//     }
//     setLoading(false);
//   }, []);

//   const saveUser = (userData) => {
//     localStorage.setItem('user', JSON.stringify(userData));
//     setUser(userData);
//   };

//   const logout = () => {
//     localStorage.removeItem('user');
//     setUser(null);
//   };

//   return (
//     <UserContext.Provider value={{ user, loading, saveUser, logout }}>
//       {children}
//     </UserContext.Provider>
//   );
// };

// export const useUser = () => useContext(UserContext);

import React, { createContext, useContext, useState, useEffect } from 'react';

// 创建上下文
const UserContext = createContext();

// Provider 组件
export const UserProvider = ({ children }) => {
  const [user, setUser] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const storedUser = localStorage.getItem('user');
    if (storedUser) {
      setUser(JSON.parse(storedUser));
    } else {
      // 设置默认用户
      const defaultUser = { id: 1, name: '测试用户' };
      localStorage.setItem('user', JSON.stringify(defaultUser));
      setUser(defaultUser);
    }
    setLoading(false);
  }, []);

  const saveUser = (userData) => {
    localStorage.setItem('user', JSON.stringify(userData));
    setUser(userData);
  };

  const logout = () => {
    localStorage.removeItem('user');
    setUser(null);
  };

  // ✅ 加载完用户数据后再渲染子组件，避免子组件访问 null
  if (loading) {
    return <div>正在加载用户信息...</div>;
  }

  return (
    <UserContext.Provider value={{ user, saveUser, logout }}>
      {children}
    </UserContext.Provider>
  );
};

// 自定义 hook
export const useUser = () => useContext(UserContext);
