import React, { useState } from'react';
import axios from 'axios';

const DeletePost = ({ post_id }) => {
  const [isDeleting, setIsDeleting] = useState(false);

  const handleDelete = async () => {
    setIsDeleting(true);
    try {
      await axios.delete(`/echo/forum/posts/${post_id}`);
      console.log('帖子删除成功');
      // 可添加删除成功后的其他逻辑，如刷新列表等
    } catch (error) {
      console.error('Error deleting post:', error);
    } finally {
      setIsDeleting(false);
    }
  };

  return (
    <button onClick={handleDelete} disabled={isDeleting}>
      {isDeleting? '删除中...' : '删除帖子'}
    </button>
  );
};

export default DeletePost;