import React, { useState, useEffect } from'react';
import axios from 'axios';

const EditPost = ({ post_id }) => {
  const [title, setTitle] = useState('');
  const [postContent, setPostContent] = useState('');
  const [imgUrl, setImgUrl] = useState('');

  useEffect(() => {
    const fetchPost = async () => {
      try {
        const response = await axios.get(`/echo/forum/posts/${post_id}`);
        setTitle(response.data.title);
        setPostContent(response.data.Postcontent);
        setImgUrl(response.data.imgUrl);
      } catch (error) {
        console.error('Error fetching post for edit:', error);
      }
    };
    fetchPost();
  }, [post_id]);

  const handleSubmit = async (e) => {
    e.preventDefault();
    try {
      await axios.put(`/echo/forum/posts/${post_id}/editPost`, {
        title,
        Postcontent: postContent,
        imgUrl
      });
      console.log('帖子更新成功');
      // 可添加其他逻辑，如跳转等
    } catch (error) {
      console.error('Error editing post:', error);
    }
  };

  return (
    <form onSubmit={handleSubmit}>
      <input
        type="text"
        placeholder="标题"
        value={title}
        onChange={(e) => setTitle(e.target.value)}
      />
      <textarea
        placeholder="内容"
        value={postContent}
        onChange={(e) => setPostContent(e.target.value)}
      />
      <input
        type="text"
        placeholder="图片URL"
        value={imgUrl}
        onChange={(e) => setImgUrl(e.target.value)}
      />
      <button type="submit">更新帖子</button>
    </form>
  );
};

export default EditPost;