// import React, { useState } from 'react';
// import axios from 'axios';
// import './CreatePost.css'; // 如果你打算加样式

// 

// const CreatePost = ({ user_id }) => {
//   const [title, setTitle] = useState('');
//   const [content, setContent] = useState('');
//   const [imageUrl, setImageUrl] = useState('');
//   const [message, setMessage] = useState('');
//   const [error, setError] = useState('');

//   const handleSubmit = async (e) => {
//     e.preventDefault();
//     setMessage('');
//     setError('');

//     if (!title.trim() || !content.trim()) {
//       setError('标题和内容不能为空');
//       return;
//     }

//     try {
//       const res = await axios.post(`/echo/forum/posts/${user_id}/createPost`, {
//         title,
//         post_content: content,
//         image_url: imageUrl
//       });

//       setMessage(`发帖成功，帖子ID：${res.data.post_id}`);
//       setTitle('');
//       setContent('');
//       setImageUrl('');
//     } catch (err) {
//       console.error(err);
//       setError(err.response?.data?.error || '发帖失败，请稍后重试');
//     }
//   };

//   return (
//     <div className="create-post-container">
//       <h2>发表新帖子</h2>
//       <form onSubmit={handleSubmit} className="create-post-form">
//         <div className="form-group">
//           <label>标题：</label>
//           <input
//             type="text"
//             value={title}
//             onChange={(e) => setTitle(e.target.value)}
//             placeholder="输入帖子标题"
//           />
//         </div>
//         <div className="form-group">
//           <label>内容：</label>
//           <textarea
//             value={content}
//             onChange={(e) => setContent(e.target.value)}
//             placeholder="输入帖子内容"
//           />
//         </div>
//         <div className="form-group">
//           <label>图片链接（可选）：</label>
//           <input
//             type="text"
//             value={imageUrl}
//             onChange={(e) => setImageUrl(e.target.value)}
//             placeholder="例如：https://example.com/img.jpg"
//           />
//         </div>
//         <button type="submit">发布</button>
//       </form>

//       {message && <p className="success-text">{message}</p>}
//       {error && <p className="error-text">{error}</p>}
//     </div>
//   );
// };

// export default CreatePost;

import React, { useState } from 'react';
import axios from 'axios';
import './CreatePost.css'; // 如果你打算加样式



const CreatePost = ({ user_id }) => {
  const [title, setTitle] = useState('');
  const [content, setContent] = useState('');
  const [imageUrl, setImageUrl] = useState('');
  const [message, setMessage] = useState('');
  const [error, setError] = useState('');

  const handleSubmit = async (e) => {
    e.preventDefault();
    setMessage('');
    setError('');

    if (!title.trim() || !content.trim()) {
      setError('标题和内容不能为空');
      return;
    }

    try {
      const res = await axios.post(`/echo/forum/posts/${user_id}/createPost`, {
        title,
        post_content: content,
        image_url: imageUrl
      });

      setMessage(`发帖成功，帖子ID：${res.data.post_id}`);
      setTitle('');
      setContent('');
      setImageUrl('');
    } catch (err) {
      console.error(err);
      setError(err.response?.data?.error || '发帖失败，请稍后重试');
    }
  };

  return (
    <div className="create-post-container">
      <h2>发表新帖子</h2>
      <form onSubmit={handleSubmit} className="create-post-form">
        <div className="form-group">
          {/* 这里加上htmlFor，并给input加id */}
          <label htmlFor="title">标题：</label>
          <input
            id="title"  // 加id
            type="text"
            value={title}
            onChange={(e) => setTitle(e.target.value)}
            placeholder="输入帖子标题"
          />
        </div>
        <div className="form-group">
          {/* 同理，内容 */}
          <label htmlFor="content">内容：</label>
          <textarea
            id="content"  // 加id
            value={content}
            onChange={(e) => setContent(e.target.value)}
            placeholder="输入帖子内容"
          />
        </div>
        <div className="form-group">
          {/* 图片链接 */}
          <label htmlFor="imageUrl">图片链接（可选）：</label>
          <input
            id="imageUrl"  // 加id
            type="text"
            value={imageUrl}
            onChange={(e) => setImageUrl(e.target.value)}
            placeholder="例如：https://example.com/img.jpg"
          />
        </div>
        <button type="submit">发布</button>
      </form>

      {message && <p className="success-text">{message}</p>}
      {error && <p className="error-text">{error}</p>}
    </div>
  );
};

export default CreatePost;
