import axios from 'axios';




// 获取帖子详情
export const getPostDetail = async (post_id) => {
    const response = await axios.get(`/echo/forum/posts/${post_id}/getPost`);
    return response.data;
};

// 获取帖子评论
export const getPostComments = async (post_id) => {
    const response = await axios.get(`/echo/forum/posts/${post_id}/getAllComments`);
    return response.data;
};

// 添加评论
export const addCommentToPost = async (postId, commentPayload) => {
  const res = await fetch(`/echo/forum/posts/${postId}/comments`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(commentPayload),
  });

  if (!res.ok) {
    throw new Error('请求失败，状态码：' + res.status);
  }

  // 试着解析 JSON，如果失败则返回 null（可能是空响应）
  try {
    const data = await res.json();
    return data;
  } catch {
    return null;
  }
};



// 点赞评论
export const likeComment = async (commentId) => {
    const response = await axios.post(`/echo/forum/comments/${commentId}/like`);
    return response.data;
};

// 取消点赞评论
export const unlikeComment = async (commentId) => {
    const response = await axios.delete(`/echo/forum/comments/${commentId}/unlike`);
    return response.data;
};

// 点赞帖子
export const likePost = async (post_id, userId) => {
    try {
        const response = await axios.post(`/echo/forum/posts/${post_id}/like`, {
            user_id: userId,
        });
        return response.data;
    } catch (error) {
        return handleApiError(error);
    }
};

// 取消点赞帖子（改为 POST 请求，携带 user_id）
export const unlikePost = async (post_id, userId) => {
    try {
        const response = await axios.post(`/echo/forum/posts/${post_id}/unlike`, {
            user_id: userId,
        });
        return response.data;
    } catch (error) {
        return handleApiError(error);
    }
};

// 收藏帖子
export const collectPost = async (post_id, userId) => {
    try {
        const response = await axios.post(`/echo/forum/posts/${post_id}/collect`, {
            user_id: userId,
        });
        return response.data;
    } catch (error) {
        return handleApiError(error);
    }
};

// 取消收藏帖子（使用 POST 请求）
export const uncollectPost = async (post_id, userId) => {
    try {
        const response = await axios.post(`/echo/forum/posts/${post_id}/uncollect`, {
            user_id: userId,
        });
        return response.data;
    } catch (error) {
        return handleApiError(error);
    }
};


export const getUserInfo = async (userId) => {
    const response = await axios.get(`/user/${userId}/info`);
    return response.data;
};

// 错误处理
const handleApiError = (error) => {
    if (error.response) {
        return {
            success: false,
            message: error.response.data.error || '请求失败',
        };
    } else if (error.request) {
        return {
            success: false,
            message: '请求未得到响应，请稍后重试',
        };
    } else {
        return {
            success: false,
            message: error.message || '发生了未知错误',
        };
    }
};
