import React, { useState } from 'react';
import './SearchBar.css';

const SearchBar = ({ onSearch }) => {
  const [query, setQuery] = useState('');

  const handleSearch = () => onSearch(query);
  const handleReset = () => {
    setQuery('');
    onSearch('');
  };

  return (
    <div className="search-bar">
      <input
        type="text"
        value={query}
        onChange={e => setQuery(e.target.value)}
        placeholder="输入要搜索的帖子"
        className="search-input"
      />
      <button onClick={handleSearch} className="search-btn">搜索</button>
      <button onClick={handleReset} className="search-btn">重置</button>
    </div>
  );
};

export default SearchBar;
