import React, { useEffect, useState } from 'react';
import axios from 'axios';
import './UserProfile.css';
import UserNav from './UserNav'; // 导入 UserNav 组件
import Header from '../../components/Header';


const API_BASE = 'http://127.0.0.1:4523/m1/6139971-5831803-default'; 

const UserProfile = () => {
  const [userProfile, setUserProfile] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);

  // 假设用户ID为1，实际应用中应通过认证信息获取
  const userId = 1;

  useEffect(() => {
    // 获取用户个人资料
    const fetchUserProfile = async () => {
      try {
        setLoading(true);
        const response = await axios.get(`${API_BASE}/echo/user/profile`, {
          params: { user_id: userId }
        });

        if (response.data.status === 'success') {
          setUserProfile(response.data);
        } else {
          setError('用户不存在');
        }
      } catch (err) {
        setError('请求失败，请稍后再试');
      } finally {
        setLoading(false);
      }
    };

    fetchUserProfile();
  }, [userId]);

  if (loading) {
    return <p>加载中...</p>;
  }

  if (error) {
    return <p className="error">{error}</p>;
  }

  return (
    <div className="user-profile-container">
      <Header /> {/* 引入 Header 组件 */}
    <div className="user-center">
      <div className="user-nav-container">
        <UserNav /> {/* 引入导航栏 */}
      </div>
      <div className="common-card">
      <div className="right-content">
        <div className="profile-header">
          <img
            src={userProfile.avatar_url}
            alt={userProfile.nickname}
            className="avatar"
          />
          <h1>{userProfile.nickname}</h1>
        </div>

        <div className="profile-details">
          {/* <h2>个人资料</h2> */}
          <p><strong>邮箱：</strong>{userProfile.email}</p>
          <p><strong>性别：</strong>{userProfile.gender}</p>
          <p><strong>个人简介：</strong>{userProfile.bio}</p>
          <p><strong>兴趣：</strong>{userProfile.interests.join(', ')}</p>
          <p><strong>等级：</strong>{userProfile.level}</p>
          <p><strong>经验：</strong>{userProfile.experience}</p>
          <p><strong>上传量：</strong>{userProfile.upload_amount}</p>
          <p><strong>下载量：</strong>{userProfile.download_amount}</p>
          <p><strong>分享率：</strong>{(userProfile.share_rate * 100).toFixed(2)}%</p>
          <p><strong>VIP：</strong>{userProfile.is_vip ? '是' : '否'}</p>
          {userProfile.is_vip && <p><strong>VIP等级：</strong>{userProfile.vip_type}</p>}
          <p><strong>加入时间：</strong>{new Date(userProfile.joined_date).toLocaleDateString()}</p>
        </div>
      </div>
      </div>
      </div>
    </div>
  );
};

export default UserProfile;    
