package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.PeerInfo;
import com.pt5.pthouduan.entity.User;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.*;
import org.apache.ibatis.type.JdbcType;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author ljx
 * @since 2025-04-14
 */
@Repository
public interface UserMapper extends BaseMapper<User> {
    @Insert("INSERT INTO user(username, password, email, passkey) VALUES(#{username}, #{password}, #{email}, #{passkey})")
    int insert(User user);

    @Delete("DELETE FROM user WHERE username = #{username})")
    int deleteByUsername(@Param("username") String username);

    @Select("SELECT * FROM user WHERE username = #{username}")
    Map<String, Object> selectByUsername(String username);

    @Select("SELECT username FROM user WHERE email = #{email}")
    String selectByEmail(String email);

    @Select("SELECT credit FROM user WHERE username = #{username}")
    int getcreditByUsername(String username);

    @Update("UPDATE user SET credit = credit - #{price} WHERE username = #{username}")
    int deductCreditByUsername(@Param("username") String username, @Param("price") int price);

    @Update("UPDATE user SET user_upload = user_upload + #{upload} WHERE username = #{username}")
    int increaseUploadByUsername(@Param("username") String username, @Param("upload") Integer upload);

    @Update("UPDATE user SET password = #{password} WHERE username = #{username}")
    int updatePassword(@Param("username") String username, @Param("password") String password);

    @Update("UPDATE user SET sex = #{sex} WHERE username = #{username}")
    int updatesex(@Param("username") String username, @Param("sex") String sex);

    @Update("UPDATE user SET image = #{image} WHERE username = #{username}")
    int updateimage(@Param("username") String username, @Param("image") String image);

    @Update("UPDATE user SET grade_id = #{gradeId} WHERE username = #{username}")
    int updateGrade(@Param("username") String username, @Param("gradeId") Integer gradeId);

    @Update("UPDATE user SET decoration = CONCAT(IFNULL(decoration, ''), ' ', #{newDecoration}) WHERE username = #{username}")
    int appendUserDecoration(@Param("username") String username, @Param("newDecoration") String newDecoration);

    boolean existsByPasskey(String passkey);
    void incrementUserTraffic( @Param("info_hash") String infoHash,@Param("passkey") String passkey, @Param("user_upload") long uploaded, @Param("user_download") long downloaded);

    String getUsernameByPasskey(String passkey);

    List<PeerInfo> findSeedersByInfoHash(@Param("infoHash") String infoHash);

    @Select("SELECT passkey FROM user WHERE userid = #{userid}")
    String selectPasskeyByUserid(Long userid);

    @Select("SELECT username, passkey, grade_id FROM user")
    List<Map<String, Object>> selectAllUsersBasicInfo();

    @Select("SELECT username FROM user WHERE userid = #{userid}")
    String selectUsernameByUserid(Long userid);

    @Select("SELECT image,decoration,username,grade_id FROM user WHERE userid = #{userid}")
    Map<String, Object> selectdecorationByUserid(Long userid);

    @Select("SELECT userid FROM user WHERE username = #{username}")
    String selectUseridByusername(String username);

    @Select("SELECT * FROM user")
    List<Map<String, Object>> selectAllUsers();

    @Select("SELECT * FROM user WHERE username REGEXP #{regexPattern}")
    List<Map<String, Object>> selectUserByFuzzyKeyword(@Param("regexPattern") String regexPattern);

    @Update("UPDATE user SET credit = credit + #{price} WHERE username = #{username}")
    int addCreditByUsername(@Param("username") String username, @Param("price") int price);

    @Select("SELECT permission FROM user WHERE userid = #{userid}")
    int getpermissionByUserid(Long userid);

}
