package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.Complain;

import java.util.List;

/**
 * <p>
 * 投诉服务接口
 * </p>
 *
 * 功能：增、删、改、查（按被投诉用户ID、投诉发起人ID）
 *
 * @author ym
 * @since 2025-04-14
 */
public interface ComplainService {

    // 创建投诉
    Complain createComplain(Complain complain);

    // 删除投诉
    boolean deleteComplain(Integer complainid);

    // 更新投诉
    boolean updateComplain(Complain complain);

    // 根据被投诉用户ID查询投诉
    List<Complain> getComplainsByTargetUser(Long duser);

    // 根据投诉发起人ID查询投诉
    List<Complain> getComplainsByPostingUser(Long puse);

    List<Complain> getAllComplains();

    Complain getComplainById(Integer complainid);

}
