package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.*;
import com.pt5.pthouduan.mapper.*;
import com.pt5.pthouduan.service.TorrentService;
import com.pt5.pthouduan.util.TorrentParser;
import com.turn.ttorrent.bcodec.BDecoder;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.tracker.TrackedTorrent;
import com.turn.ttorrent.tracker.Tracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class TorrentServiceImpl implements TorrentService {

    @Value("${tracker.url}")  //等等看看这个有没有传进来
    private String trackerUrl;
    @Value("${torrent.file-save-dir}")
    private String fileSaveDir;

    @Value("${torrent.cover-image-dir}")
    private String coverImageDir;
    @Autowired
    private TorrentMapper torrentMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired  // 确保使用接口类型（推荐）
    private Tracker tracker;
    @Autowired
    private MovieInfoMapper movieInfoMapper;
    // 🎵 Music 音乐
    @Autowired
    private MusicInfoMapper musicInfoMapper;

    // 🎮 Game 游戏
    @Autowired
    private GameInfoMapper gameInfoMapper;

    // 📺 TV 剧集
    @Autowired
    private TvInfoMapper tvInfoMapper;

    // 🧸 Anime 动漫
    @Autowired
    private AnimeInfoMapper animeInfoMapper;

    // 📚 Learning 学习
    @Autowired
    private EduInfoMapper eduInfoMapper;

    // � Software 软件
    @Autowired
    private SoftwareInfoMapper softwareInfoMapper;

    // 🎤 Variety 综艺
    @Autowired
    private ShowInfoMapper showInfoMapper;

    // ⚽ Sports 体育
    @Autowired
    private SportInfoMapper sportInfoMapper;

    // 🎬 Documentary 纪录片
    @Autowired
    private DocumentaryInfoMapper documentaryInfoMapper;

    // 📦 Other 其他
    @Autowired
    private OtherInfoMapper otherInfoMapper;


    public List<Torrent> getAllTorrents() {
        return torrentMapper.getAllTorrents();
    }
    public List<Torrent> getTorrentsByCategory(Integer category) {
        return torrentMapper.selectTorrentsByCategory(category);
    }
    public Torrent getTorrentById(Long id) {
        return torrentMapper.selectById(id);
    }



//    @Override
//    public void Upload(MultipartFile torrentFile, String title, String description, User user) throws Exception {
//        //读取torrent文件
//        InputStream inputStream = torrentFile.getInputStream();
//        //解析torrent文件
//        byte[] torrentData = torrentFile.getBytes();
//        Torrent torrent = TorrentParser.parse(torrentData);
//        //验证info_hash是否存在
//        Integer result;
//        result = torrentMapper.existsByInfoHash(torrent.getInfoHash());
//        if(result >= 1){
//            throw new IllegalArgumentException("Torrent already exists");
//        }
//        String fileSavePath = "D:/torrenttest/" + torrentFile.getOriginalFilename();
//        torrentFile.transferTo(new File(fileSavePath));
//        // 4. 注册到Tracker（关键步骤！）
//        TrackedTorrent trackedTorrent = TrackedTorrent.load(new File(fileSavePath));
//        tracker.announce(trackedTorrent);
//        //存入数据库
//        Torrent entity = new Torrent();
//        entity.setInfoHash(torrent.getInfoHash());
//        entity.setUploader_id(user.getUserid());
//        entity.setTorrentTitle(title);
//        entity.setDescription(description);
//        entity.setTorrentSize(torrent.getTorrentSize());
//        entity.setFilename(torrentFile.getOriginalFilename());
//        entity.setPath(fileSavePath); // 保存路径到数据库
//        torrentMapper.save(entity);
//    }
@Override
public ResponseEntity<Resource> Upload(MultipartFile torrentFile, String title, String description, Integer categoryId, String dpi, String caption,User user) throws Exception {
    //读取torrent文件
    InputStream inputStream = torrentFile.getInputStream();
    // === 1. 基础校验 ===
    if (torrentFile.isEmpty()) {
        throw new IllegalArgumentException("Torrent file cannot be empty");
    }
    // === 2. 注入passkey ===
    byte[] modifiedData = addPasskeyToTorrent(torrentFile.getBytes(), "111111");
    Torrent torrent = TorrentParser.parse(modifiedData);
    // === 4. 检查重复 ===
    if (torrentMapper.existsByInfoHash(torrent.getInfoHash()) >= 1) {
        throw new IllegalArgumentException("Torrent already exists");
    }
    String fileSavePath = "D:/torrenttest/" + torrentFile.getOriginalFilename();
    //torrentFile.transferTo(new File(fileSavePath));
    Files.write(new File(fileSavePath).toPath(), modifiedData);
    // 4. 注册到Tracker（关键步骤！）
    TrackedTorrent trackedTorrent = TrackedTorrent.load(new File(fileSavePath));
    tracker.announce(trackedTorrent);
    //存入数据库
    Torrent entity = new Torrent();
    entity.setInfoHash(torrent.getInfoHash());
    entity.setUploader_id(user.getUserid());
    entity.setTorrentTitle(title);
    entity.setDescription(description);
    entity.setTorrentSize(torrent.getTorrentSize());
    entity.setFilename(torrentFile.getOriginalFilename());
    entity.setCategoryid(categoryId);
    entity.setCaption(caption);
    entity.setDpi(dpi);
    entity.setUploadTime(LocalDateTime.now());
    entity.setPath(fileSavePath); // 保存路径到数据库
    torrentMapper.save(entity);
    // 返回修改后的.torrent文件给用户下载
    ByteArrayResource resource = new ByteArrayResource(modifiedData);
    // 2. 设置正确的Content-Type
    // 构建响应，下载.torrent文件
    // 构建响应，下载.torrent文件
//    HttpHeaders headers = new HttpHeaders();
//    headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
//    headers.setContentDisposition(ContentDisposition.attachment()
//            .filename(torrentFile.getOriginalFilename())
//            .build());
//    return new ResponseEntity<>(resource, headers, HttpStatus.OK);
    return ResponseEntity.ok()
            .header(HttpHeaders.CONTENT_DISPOSITION,
                    "attachment; filename=\"" + URLEncoder.encode(torrentFile.getOriginalFilename(), "UTF-8") + "\"")
            .contentType(MediaType.parseMediaType("application/x-bittorrent"))
            .body(new ByteArrayResource(modifiedData));
}

    @Override
    public void deleteTorrent(Long userid,Long torrentId) {
        // 1. 验证权限
        Torrent torrent = torrentMapper.selectById(torrentId);

        if (userMapper.getpermissionByUserid(userid) != 1  &&
                !torrent.getUploader_id().equals(userid) ){
            throw new SecurityException("无权删除此资源");
        }


        // 3. 删除数据库记录（级联删除依赖数据库外键配置）
        torrentMapper.deleteById(torrent.getTorrentid());
    }

    public void setPromotion(Long torrentId, Long promotionId, Long userId) {
        // 1. 检查种子是否存在
        Torrent torrent = torrentMapper.selectById(torrentId);

        // 2. 检查权限（假设只有上传者或管理员可以修改）
        int permission = userMapper.getpermissionByUserid(userId);
        if (permission != 1) {
            throw new SecurityException("无权修改该种子");
        }

        // 3. 设置促销类型
        //1-上传加倍；2-下载减半；3-免费下载；NULL-没有促销
        torrentMapper.setpromotion(torrentId,promotionId);
    }

    @Override
    public void addcredit(Long manageid, Long userid, Integer credit) {
        int permission = userMapper.getpermissionByUserid(manageid);
        if (permission != 1) {
            throw new SecurityException("无权修改该种子");
        }
        String username = userMapper.selectUsernameByUserid(userid);

        userMapper.addCreditByUsername(username,credit);
    }

    @Override
    public void deducecredit(Long manageid, Long userid, Integer credit) {
        int permission = userMapper.getpermissionByUserid(manageid);
        if (permission != 1) {
            throw new SecurityException("无权修改该种子");
        }
        String username = userMapper.selectUsernameByUserid(userid);

        userMapper.deductCreditByUsername(username,credit);
    }

    @Override
    public ResponseEntity<Resource> uploadWithCategoryAndCover(MultipartFile torrentFile, MultipartFile coverImage, String title, String description, Integer categoryId, Long userid, Map<String, String> extraParams) throws Exception {
        try {
            // === 1. 基础校验 ===
            if (torrentFile.isEmpty()) {
                throw new IllegalArgumentException("Torrent file cannot be empty");
            }
            File dir = new File(fileSaveDir);
            if (!dir.exists()) {
                boolean created = dir.mkdirs();  // 递归创建目录
                if (!created) {
                    throw new IOException("无法创建目录：" + fileSaveDir);
                }
            }

            // === 2. 注入passkey ===
            byte[] modifiedData = addPasskeyToTorrent(torrentFile.getBytes(), userMapper.selectPasskeyByUserid(userid));
            Torrent torrent = TorrentParser.parse(modifiedData);

            System.out.println("是否已存在 info_hash：" + torrentMapper.existsByInfoHash(torrent.getInfoHash()));

            // === 3. 检查重复 ===
            if (torrentMapper.existsByInfoHash(torrent.getInfoHash()) >= 1) {
                throw new IllegalArgumentException("Torrent already exists");
            }

            // === 4. 存储种子文件 ===
            String fileSavePath = fileSaveDir + torrentFile.getOriginalFilename();
            Files.write(new File(fileSavePath).toPath(), modifiedData);
            System.out.println("Modified torrent file size: " + modifiedData.length);

            // === 5. 注册到Tracker ===
            TrackedTorrent trackedTorrent = TrackedTorrent.load(new File(fileSavePath));
            tracker.announce(trackedTorrent);

            // === 6. 存入数据库主表 ===
            Torrent entity = new Torrent();
            entity.setInfoHash(torrent.getInfoHash());
            entity.setUploader_id(userid);
            entity.setTorrentTitle(title);
            entity.setDescription(description);
            entity.setTorrentSize(torrent.getTorrentSize());
            entity.setFilename(torrentFile.getOriginalFilename());
            entity.setCategoryid(categoryId);
            entity.setUploadTime(LocalDateTime.now());
            entity.setPath(fileSavePath);

            torrentMapper.save(entity);



            // === 7. 分类插入扩展信息 ===
            switch (categoryId) {
                case 1:
                    MovieInfo movie = new MovieInfo();
                    movie.setTorrentid(entity.getTorrentid());
                    movie.setRegion(extraParams.get("region"));
                    movie.setYear(extraParams.get("year") != null ? Integer.parseInt(extraParams.get("year")) : null);
                    movie.setGenre(extraParams.get("genre"));
                    movie.setCodecFormat(extraParams.get("codecFormat"));
                    movie.setResolution(extraParams.get("resolution"));
                    movieInfoMapper.insert(movie);
                    break;
                case 3:
                    MusicInfo music = new MusicInfo();
                    music.setTorrentid(entity.getTorrentid());
                    music.setGenre(extraParams.get("genre"));
                    music.setRegion(extraParams.get("region"));
                    music.setStyle(extraParams.get("style"));
                    music.setFormat(extraParams.get("format"));
                    musicInfoMapper.insert(music);
                    break;
                case 5:
                    GameInfo game = new GameInfo();
                    game.setTorrentid(entity.getTorrentid());
                    game.setPlatform(extraParams.get("platform"));
                    game.setGenre(extraParams.get("genre"));
                    game.setFormat(extraParams.get("dataType"));
                    game.setLanguage(extraParams.get("language"));
                    gameInfoMapper.insert(game);
                    break;
                case 2:
                    TvInfo tv = new TvInfo();
                    tv.setTorrentId(entity.getTorrentid());
                    tv.setRegion(extraParams.get("region"));
                    tv.setFormat(extraParams.get("format"));
                    tv.setGenre(extraParams.get("genre"));
                    tvInfoMapper.insert(tv);
                    break;
                case 4:
                    AnimeInfo anime = new AnimeInfo();
                    anime.setTorrentid(entity.getTorrentid());
                    anime.setGenre(extraParams.get("genre"));
                    anime.setFormat(extraParams.get("format"));
                    anime.setResolution(extraParams.get("resolution"));
                    animeInfoMapper.insert(anime);
                    break;
                case 9:
                    EduInfo learning = new EduInfo();
                    learning.setTorrentid(entity.getTorrentid());
                    learning.setGenre(extraParams.get("genre"));
                    learning.setFormat(extraParams.get("format"));
                    eduInfoMapper.insert(learning);
                    break;
                case 8:
                    SoftwareInfo software = new SoftwareInfo();
                    software.setTorrentid(entity.getTorrentid());
                    software.setPlatform(extraParams.get("platform"));
                    software.setGenre(extraParams.get("genre"));
                    software.setFormat(extraParams.get("format"));
                    softwareInfoMapper.insert(software);
                    break;
                case 6:
                    ShowInfo variety = new ShowInfo();
                    variety.setTorrentid(entity.getTorrentid());
                    variety.setIsMainland(Boolean.valueOf(extraParams.get("mainland")));
                    variety.setGenre(extraParams.get("genre"));
                    variety.setFormat(extraParams.get("format"));
                    showInfoMapper.insert(variety);
                    break;
                case 7:
                    SportInfo sports = new SportInfo();
                    sports.setTorrentid(entity.getTorrentid());
                    sports.setGenre(extraParams.get("genre"));
                    sports.setEventType(extraParams.get("eventType"));
                    sports.setFormat(extraParams.get("format"));
                    sportInfoMapper.insert(sports);
                    break;
                case 10:
                    DocumentaryInfo doc = new DocumentaryInfo();
                    doc.setTorrentid(entity.getTorrentid());
                    doc.setYear(extraParams.get("year") != null ? Integer.parseInt(extraParams.get("year")) : null);
                    doc.setSource(extraParams.get("source"));
                    doc.setFormat(extraParams.get("format"));
                    documentaryInfoMapper.insert(doc);
                    break;
                case 11:
                    OtherInfo other = new OtherInfo();
                    other.setTorrentid(entity.getTorrentid());
                    other.setGenre(extraParams.get("genre"));
                    otherInfoMapper.insert(other);
                    break;
                default:
                    System.out.println("不支持的分类，或无扩展表记录");
            }

            // === 8. 封面图片处理 ===
            if (coverImage != null && !coverImage.isEmpty()) {
                String coverImagePath = storeCoverImage(coverImage);
                System.out.println(coverImagePath);
                entity.setCoverImagePath(coverImagePath);
                torrentMapper.updateCoverImagePath(entity.getTorrentid(), coverImagePath);
            }

            System.out.println("运行到这里了");

            // === 9. 返回修改后的torrent文件 ===
            return ResponseEntity.ok()
                    .header(HttpHeaders.CONTENT_DISPOSITION,
                            "attachment; filename=\"" + URLEncoder.encode(torrentFile.getOriginalFilename(), "UTF-8") + "\"")
                    .contentType(MediaType.parseMediaType("application/x-bittorrent"))
                    .cacheControl(CacheControl.noCache())
                    .body(new ByteArrayResource(modifiedData));
        } catch (Exception e) {
            System.err.println("上传失败，发生异常：" + e.getMessage());
            e.printStackTrace();  // 打印完整堆栈
            return ResponseEntity.status(500).body(new ByteArrayResource(("上传失败: " + e.getMessage()).getBytes()));
        }
    }

    @Override
    public ResponseEntity<Resource> uploadtohelp(int requestId,MultipartFile torrentFile, MultipartFile coverImage, String title, String description, Integer categoryId, Long userid, Map<String, String> extraParams) {
        try {
            // === 1. 基础校验 ===
            if (torrentFile.isEmpty()) {
                throw new IllegalArgumentException("Torrent file cannot be empty");
            }
            File dir = new File(fileSaveDir);
            if (!dir.exists()) {
                boolean created = dir.mkdirs();  // 递归创建目录
                if (!created) {
                    throw new IOException("无法创建目录：" + fileSaveDir);
                }
            }

            // === 2. 注入passkey ===
            byte[] modifiedData = addPasskeyToTorrent(torrentFile.getBytes(), userMapper.selectPasskeyByUserid(userid));
            Torrent torrent = TorrentParser.parse(modifiedData);

            System.out.println("是否已存在 info_hash：" + torrentMapper.existsByInfoHash(torrent.getInfoHash()));

            // === 3. 检查重复 ===
            if (torrentMapper.existsByInfoHash(torrent.getInfoHash()) >= 1) {
                throw new IllegalArgumentException("Torrent already exists");
            }

            // === 4. 存储种子文件 ===
            String fileSavePath = fileSaveDir + torrentFile.getOriginalFilename();
            Files.write(new File(fileSavePath).toPath(), modifiedData);
            System.out.println("Modified torrent file size: " + modifiedData.length);

            // === 5. 注册到Tracker ===
            TrackedTorrent trackedTorrent = TrackedTorrent.load(new File(fileSavePath));
            tracker.announce(trackedTorrent);

            // === 6. 存入数据库主表 ===
            Torrent entity = new Torrent();
            entity.setInfoHash(torrent.getInfoHash());
            entity.setUploader_id(userid);
            entity.setTorrentTitle(title);
            entity.setDescription(description);
            entity.setTorrentSize(torrent.getTorrentSize());
            entity.setFilename(torrentFile.getOriginalFilename());
            entity.setCategoryid(categoryId);
            entity.setUploadTime(LocalDateTime.now());
            entity.setPath(fileSavePath);

            torrentMapper.save(entity);

            torrentMapper.updaterequest(requestId,entity.getTorrentid());


            // === 7. 分类插入扩展信息 ===
            switch (categoryId) {
                case 1:
                    MovieInfo movie = new MovieInfo();
                    movie.setTorrentid(entity.getTorrentid());
                    movie.setRegion(extraParams.get("region"));
                    movie.setYear(extraParams.get("year") != null ? Integer.parseInt(extraParams.get("year")) : null);
                    movie.setGenre(extraParams.get("genre"));
                    movie.setCodecFormat(extraParams.get("codecFormat"));
                    movie.setResolution(extraParams.get("resolution"));
                    movieInfoMapper.insert(movie);
                    break;
                case 3:
                    MusicInfo music = new MusicInfo();
                    music.setTorrentid(entity.getTorrentid());
                    music.setGenre(extraParams.get("genre"));
                    music.setRegion(extraParams.get("region"));
                    music.setStyle(extraParams.get("style"));
                    music.setFormat(extraParams.get("format"));
                    musicInfoMapper.insert(music);
                    break;
                case 5:
                    GameInfo game = new GameInfo();
                    game.setTorrentid(entity.getTorrentid());
                    game.setPlatform(extraParams.get("platform"));
                    game.setGenre(extraParams.get("genre"));
                    game.setFormat(extraParams.get("dataType"));
                    game.setLanguage(extraParams.get("language"));
                    gameInfoMapper.insert(game);
                    break;
                case 2:
                    TvInfo tv = new TvInfo();
                    tv.setTorrentId(entity.getTorrentid());
                    tv.setRegion(extraParams.get("region"));
                    tv.setFormat(extraParams.get("format"));
                    tv.setGenre(extraParams.get("genre"));
                    tvInfoMapper.insert(tv);
                    break;
                case 4:
                    AnimeInfo anime = new AnimeInfo();
                    anime.setTorrentid(entity.getTorrentid());
                    anime.setGenre(extraParams.get("genre"));
                    anime.setFormat(extraParams.get("format"));
                    anime.setResolution(extraParams.get("resolution"));
                    animeInfoMapper.insert(anime);
                    break;
                case 9:
                    EduInfo learning = new EduInfo();
                    learning.setTorrentid(entity.getTorrentid());
                    learning.setGenre(extraParams.get("genre"));
                    learning.setFormat(extraParams.get("format"));
                    eduInfoMapper.insert(learning);
                    break;
                case 8:
                    SoftwareInfo software = new SoftwareInfo();
                    software.setTorrentid(entity.getTorrentid());
                    software.setPlatform(extraParams.get("platform"));
                    software.setGenre(extraParams.get("genre"));
                    software.setFormat(extraParams.get("format"));
                    softwareInfoMapper.insert(software);
                    break;
                case 6:
                    ShowInfo variety = new ShowInfo();
                    variety.setTorrentid(entity.getTorrentid());
                    variety.setIsMainland(Boolean.valueOf(extraParams.get("mainland")));
                    variety.setGenre(extraParams.get("genre"));
                    variety.setFormat(extraParams.get("format"));
                    showInfoMapper.insert(variety);
                    break;
                case 7:
                    SportInfo sports = new SportInfo();
                    sports.setTorrentid(entity.getTorrentid());
                    sports.setGenre(extraParams.get("genre"));
                    sports.setEventType(extraParams.get("eventType"));
                    sports.setFormat(extraParams.get("format"));
                    sportInfoMapper.insert(sports);
                    break;
                case 10:
                    DocumentaryInfo doc = new DocumentaryInfo();
                    doc.setTorrentid(entity.getTorrentid());
                    doc.setYear(extraParams.get("year") != null ? Integer.parseInt(extraParams.get("year")) : null);
                    doc.setSource(extraParams.get("source"));
                    doc.setFormat(extraParams.get("format"));
                    documentaryInfoMapper.insert(doc);
                    break;
                case 11:
                    OtherInfo other = new OtherInfo();
                    other.setTorrentid(entity.getTorrentid());
                    other.setGenre(extraParams.get("genre"));
                    otherInfoMapper.insert(other);
                    break;
                default:
                    System.out.println("不支持的分类，或无扩展表记录");
            }

            // === 8. 封面图片处理 ===
            if (coverImage != null && !coverImage.isEmpty()) {
                String coverImagePath = storeCoverImage(coverImage);
                System.out.println(coverImagePath);
                entity.setCoverImagePath(coverImagePath);
                torrentMapper.updateCoverImagePath(entity.getTorrentid(), coverImagePath);
            }

            System.out.println("运行到这里了");

            // === 9. 返回修改后的torrent文件 ===
            return ResponseEntity.ok()
                    .header(HttpHeaders.CONTENT_DISPOSITION,
                            "attachment; filename=\"" + URLEncoder.encode(torrentFile.getOriginalFilename(), "UTF-8") + "\"")
                    .contentType(MediaType.parseMediaType("application/x-bittorrent"))
                    .cacheControl(CacheControl.noCache())
                    .body(new ByteArrayResource(modifiedData));
        } catch (Exception e) {
            System.err.println("上传失败，发生异常：" + e.getMessage());
            e.printStackTrace();  // 打印完整堆栈
            return ResponseEntity.status(500).body(new ByteArrayResource(("上传失败: " + e.getMessage()).getBytes()));
        }
    }

    /**
     * 存储封面图片
     *
     * @param coverImage 封面图片文件
     * @return 封面图片的存储路径
     */
    private String storeCoverImage(MultipartFile coverImage) throws IOException {
        // 这里可以使用你现有的 FileStorageService 或自定义存储逻辑
        // 假设使用 FileStorageService
        System.out.println("运行到这里了图片");
        File dir = new File(coverImageDir);
        if (!dir.exists()) {
            boolean created = dir.mkdirs();  // 递归创建目录
            if (!created) {
                throw new IOException("无法创建目录：" + coverImageDir);
            }
        }
        //String coverImageDir = "D:/torrenttest/covers/"; // 封面图片存储目录
        String filename = System.currentTimeMillis()+"_"+coverImage.getOriginalFilename();
        Path coverImagePath = Paths.get(coverImageDir, filename);

        try {
            Files.createDirectories(coverImagePath.getParent()); // 创建目录
            Files.copy(coverImage.getInputStream(), coverImagePath, StandardCopyOption.REPLACE_EXISTING);
        } catch (IOException e) {
            throw new RuntimeException("无法存储封面图片", e);
        }

        return "http://localhost:8080/"+coverImageDir+filename; // 返回相对路径
    }

    @Override
    public ResponseEntity<Resource> uploadWithCategory(MultipartFile torrentFile, String title, String description, Integer categoryId, Long userid, Map<String, String> extraParams ) throws Exception {
        //读取torrent文件
        InputStream inputStream = torrentFile.getInputStream();
        // === 1. 基础校验 ===
        if (torrentFile.isEmpty()) {
            throw new IllegalArgumentException("Torrent file cannot be empty");
        }
        // === 2. 注入passkey ===
        byte[] modifiedData = addPasskeyToTorrent(torrentFile.getBytes(),userMapper.selectPasskeyByUserid(userid) );
        Torrent torrent = TorrentParser.parse(modifiedData);
        // === 4. 检查重复 ===
        if (torrentMapper.existsByInfoHash(torrent.getInfoHash()) >= 1) {
            throw new IllegalArgumentException("Torrent already exists");
        }
        String fileSavePath = "D:/torrenttest/" + torrentFile.getOriginalFilename();
        //torrentFile.transferTo(new File(fileSavePath));
        Files.write(new File(fileSavePath).toPath(), modifiedData);
        // 4. 注册到Tracker（关键步骤！）
        TrackedTorrent trackedTorrent = TrackedTorrent.load(new File(fileSavePath));
        tracker.announce(trackedTorrent);
        //存入数据库
        Torrent entity = new Torrent();
        entity.setInfoHash(torrent.getInfoHash());
        entity.setUploader_id(userid);
        entity.setTorrentTitle(title);
        entity.setDescription(description);
        entity.setTorrentSize(torrent.getTorrentSize());
        entity.setFilename(torrentFile.getOriginalFilename());
        entity.setCategoryid(categoryId);
        entity.setUploadTime(LocalDateTime.now());
        entity.setPath(fileSavePath); // 保存路径到数据库
        torrentMapper.save(entity);
        switch (categoryId) {
            case 1: // 🎬 Movie 电影
                MovieInfo movie = new MovieInfo();
                movie.setTorrentid(entity.getTorrentid());
                System.out.println(entity.getTorrentid());
                movie.setRegion(extraParams.get("region"));
                movie.setYear(extraParams.get("year") != null ? Integer.parseInt(extraParams.get("year")) : null);
                movie.setGenre(extraParams.get("genre"));
                movie.setCodecFormat(extraParams.get("codecFormat"));
                movie.setResolution(extraParams.get("resolution"));
                movieInfoMapper.insert(movie);
                break;

            case 3: // 🎵 Music 音乐
                MusicInfo music = new MusicInfo();
                music.setTorrentid(entity.getTorrentid());
                music.setGenre(extraParams.get("genre"));
                music.setRegion(extraParams.get("region"));
                music.setStyle(extraParams.get("style"));
                music.setFormat(extraParams.get("format"));
                musicInfoMapper.insert(music);
                break;

            case 5: // 🎮 Game 游戏
                GameInfo game = new GameInfo();
                game.setTorrentid(entity.getTorrentid());
                game.setPlatform(extraParams.get("platform"));
                game.setGenre(extraParams.get("genre"));
                game.setFormat(extraParams.get("dataType"));
                game.setLanguage(extraParams.get("language"));
                gameInfoMapper.insert(game);
                break;

            case 2: // 📺 TV 剧集
                TvInfo tv = new TvInfo();
                tv.setTorrentId(entity.getTorrentid());
                tv.setRegion(extraParams.get("region"));
                tv.setFormat(extraParams.get("format"));
                tv.setGenre(extraParams.get("genre"));
                tvInfoMapper.insert(tv);
                break;

            case 4: // 🧸 Anime 动漫
                AnimeInfo anime = new AnimeInfo();
                anime.setTorrentid(entity.getTorrentid());
                anime.setGenre(extraParams.get("genre"));
                anime.setFormat(extraParams.get("format"));
                anime.setResolution(extraParams.get("resolution"));
                animeInfoMapper.insert(anime);
                break;

            case 9: // 📚 Learning 学习
                EduInfo learning = new EduInfo();
                learning.setTorrentid(entity.getTorrentid());
                learning.setGenre(extraParams.get("genre"));
                learning.setFormat(extraParams.get("format"));
                eduInfoMapper.insert(learning);
                break;

            case 8: // 🧰 Software 软件
                SoftwareInfo software = new SoftwareInfo();
                software.setTorrentid(entity.getTorrentid());
                software.setPlatform(extraParams.get("platform"));
                software.setGenre(extraParams.get("genre"));
                software.setFormat(extraParams.get("format"));
                softwareInfoMapper.insert(software);
                break;

            case 6: // 🎤 Variety 综艺
                ShowInfo variety = new ShowInfo();
                variety.setTorrentid(entity.getTorrentid());
                variety.setIsMainland(Boolean.valueOf(extraParams.get("mainland")));  // 是否大陆综艺
                variety.setGenre(extraParams.get("genre"));
                variety.setFormat(extraParams.get("format"));
                showInfoMapper.insert(variety);
                break;

            case 7: // ⚽ Sports 体育
                SportInfo sports = new SportInfo();
                sports.setTorrentid(entity.getTorrentid());
                sports.setGenre(extraParams.get("genre"));
                sports.setEventType(extraParams.get("eventType"));
                sports.setFormat(extraParams.get("format"));
                sportInfoMapper.insert(sports);
                break;

            case 10: // 🎬 Documentary 纪录片
                DocumentaryInfo doc = new DocumentaryInfo();
                doc.setTorrentid(entity.getTorrentid());
                doc.setYear(extraParams.get("year") != null ? Integer.parseInt(extraParams.get("year")) : null);
                doc.setSource(extraParams.get("source"));  // 节目源
                doc.setFormat(extraParams.get("format"));
                documentaryInfoMapper.insert(doc);
                break;

            case 11: // 📦 Other 其他
                OtherInfo other = new OtherInfo();
                other.setTorrentid(entity.getTorrentid());
                other.setGenre(extraParams.get("genre"));
                otherInfoMapper.insert(other);
                break;

            default:
                System.out.println("不支持的分类，或无扩展表记录");
        }

        // 返回修改后的.torrent文件给用户下载
        ByteArrayResource resource = new ByteArrayResource(modifiedData);
        // 2. 设置正确的Content-Type
        // 构建响应，下载.torrent文件
        // 构建响应，下载.torrent文件
//    HttpHeaders headers = new HttpHeaders();
//    headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
//    headers.setContentDisposition(ContentDisposition.attachment()
//            .filename(torrentFile.getOriginalFilename())
//            .build());
//    return new ResponseEntity<>(resource, headers, HttpStatus.OK);
        System.out.println("运行到这里了");
        return ResponseEntity.ok()
                .header(HttpHeaders.CONTENT_DISPOSITION,
                        "attachment; filename=\"" + torrentFile.getOriginalFilename() + "\"")
                .contentType(MediaType.parseMediaType("application/x-bittorrent"))
                .body(new ByteArrayResource(modifiedData));
    }
    // 专用方法：向torrent文件注入passkey
    private byte[] addPasskeyToTorrent(byte[] originalData, String passkey) throws Exception {
        // 1. 解析原始torrent
        BEValue decoded = BDecoder.bdecode(new ByteArrayInputStream(originalData));
        Map<String, BEValue> torrentMap = decoded.getMap();

        // 2. 修改announce URL
        String originalAnnounce = torrentMap.get("announce").getString();
        String newAnnounce = originalAnnounce.contains("?")
                ? originalAnnounce + "&passkey=" + passkey
                : originalAnnounce + "?passkey=" + passkey;

        // 3. 重建torrent文件
        torrentMap.put("announce", new BEValue(newAnnounce));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BEncoder.bencode(torrentMap, baos);
        return baos.toByteArray();
    }

    @Override
    public List<Torrent> getTorrentsByCategorywithfilters(Integer categoryid, Map<String, String> filters) {
        String extendTable = getExtendTableByCategoryId(categoryid);
        if(extendTable == null) {
            System.out.println("未知表");
        }
        return torrentMapper.listByCategoryWithFilters(categoryid,filters,extendTable);
    }

    @Override
    public List<Torrent> searchByKeyword(String keyword) {
        return torrentMapper.searchByKeyword(keyword);
    }


    private String getExtendTableByCategoryId(Integer categoryid) {
        switch(categoryid) {
            case 1:return "movie_info";
            case 2:return "tvseries_info";
            case 3:return "music_info";
            case 4:return "anime_info";
            case 5:return "game_info";
            case 6:return "variety_info";
            case 7:return "sport_info";
            case 8:return "software_info";
            case 9:return "edu_info";
            case 10:return "documentary_info";
            case 11: return "other_info";
        }
        return null;
    }

    //    @Override
//    public Torrent getTorrentFile(Long torrentid) {
//        System.out.println("查询结果：" + torrentid);
//        Torrent result = torrentMapper.selectById(torrentid);
//        if(result != null){
//            System.out.println("not null：" + torrentid);
//        }else{
//            System.out.println("null：" + torrentid);
//        }
//        return torrentMapper.selectById(torrentid);
//    }
@Override
public Torrent getTorrentFile(Long torrentid) {
    System.out.println("查询参数：" + torrentid);
    try {
        Torrent result = torrentMapper.selectById(torrentid);
        System.out.println("第一次查询结果：" + (result != null ? "非空" : "空"));
        return result;
    } catch (Exception e) {
        System.out.println("查询异常：" + e.getMessage());
        e.printStackTrace();
        return null;
    }
}


    @Override
    public Resource loadTorrentFileAsResource(String filepath) throws Exception{
        try{
            Path file = Paths.get(filepath).normalize();
            Resource resource = new UrlResource(file.toUri());

            if(resource.exists() || resource.isReadable()){
                return resource;
            }else{
                throw new Exception("Could not read file: " + filepath);
            }
        }catch(MalformedURLException e){
            throw new Exception("Could not read file: " + filepath,e);
        }
    }

    @Override
    public void incrementDownloadCount(Long torrentid) {
        torrentMapper.incrementDownloadCount(torrentid);
    }
}
