package com.pt5.pthouduan.util;

import java.util.HexFormat;

public class TorrentUtils {
    /**
     * 16进制字符串转byte[]
     * @param hexString 不带前缀的16进制字符串（如 "7a2b3c"）
     */
    public static byte[] hexStringToByteArray(String hexString) {
        // Java 17+ 推荐方式
        return HexFormat.of().parseHex(hexString);

        /* Java 8 兼容方案：
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(hexString.charAt(i), 16) << 4)
                                + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
        */
    }

    /**
     * byte[] 转16进制字符串
     */
    public static String byteArrayToHexString(byte[] bytes) {
        // Java 17+ 推荐方式
        return HexFormat.of().formatHex(bytes);

        /* Java 8 兼容方案：
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
        */
    }
}
