package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.Invites;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.pt5.pthouduan.entity.User;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Repository;

@Repository
public interface InvitesMapper extends BaseMapper<Invites> {

    @Select("SELECT * FROM invite WHERE code = #{code}")
    Invites selectByCode(String code);

    @Update("UPDATE invite SET isUsed = 1, username = #{username} WHERE code = #{code}")
    int updateInviteByCode(@Param("code") String code, @Param("username") String username);

    @Select("SELECT * FROM invite WHERE buyername = '' LIMIT 1")
    Invites selectFirstEmptyBuyername();

    @Update("UPDATE invite SET buyername = #{buyername} WHERE code = #{code}")
    int updatebuyer(@Param("code") String code, @Param("buyername") String buyername);
}
