package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.Post;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 *  帖子 Mapper 接口
 * </p>
 *
 * 功能：增、删、改、查（按关键词）、点赞、置顶、用户帖子查询、置顶帖子查询
 *
 * 作者：杨蔓
 * @since 2025-04-14
 */
@Mapper
public interface PostMapper extends BaseMapper<Post> {

    // 创建帖子
    void save(Post post);

    // 根据帖子ID删除
    int deleteByPostid(@Param("postid") Integer postid);

    // 更新帖子
    int updatePost(Post post);

    // 模糊搜索（标题或标签）
    List<Post> searchByKeyword(@Param("keyword") String keyword);

    // 点赞 +1
    int incrementLikes(@Param("postid") Integer postid);

    // 取消点赞 -1（最小为0）
    int decrementLikes(@Param("postid") Integer postid);

    // 设置置顶状态
    int updatePinnedStatus(@Param("postid") Integer postid, @Param("pinned") boolean pinned);

    // 根据用户ID查询该用户所有帖子
    List<Post> findByUserid(@Param("userid") Long userid);

    // 查询所有置顶帖子
    List<Post> findPinnedPosts();

    // ✅ 新增：查询所有帖子（置顶优先，时间倒序）
    List<Post> selectAllSorted();
}
