package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.Post;

import java.util.List;

/**
 * <p>
 *  帖子服务接口
 * </p>
 *
 * 功能：
 *  - 增、删、改、查（按标签或标题）
 *  - 点赞、取消点赞
 *  - 设置置顶状态
 *  - 可设置可见范围
 *  - 上传图片（通常可选放在 Controller）
 *  - 查找用户所有帖子
 *  - 查找置顶帖子
 *  - 获取所有帖子（置顶优先，时间倒序）
 *
 * @author 杨蔓
 * @since 2025-04-14
 */
public interface PostService {

    Post createPost(Post post);                      // 创建帖子

    boolean deletePost(Integer postid);              // 删除帖子

    boolean updatePost(Post post);                   // 更新帖子

    List<Post> searchPostsByKeyword(String keyword); // 查找帖子（标题或标签）

    boolean incrementLikes(Integer postid);          // 点赞（likes + 1）

    boolean decrementLikes(Integer postid);          // 取消点赞（likes - 1，最小为0）

    boolean setPinnedStatus(Integer postid, boolean pinned); // 设置是否置顶

    List<Post> findByUserid(Long userid);            // 根据用户 ID 获取帖子

    List<Post> findPinnedPosts();                    // 查找所有置顶帖子

    List<Post> getAllPostsSorted();                  // ✅ 获取所有帖子（置顶优先，按时间排序）
}
