package com.pt5.pthouduan.service;
import com.pt5.pthouduan.entity.Invites;
import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.mapper.InvitesMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.pt5.pthouduan.mapper.UserMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import java.security.SecureRandom;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Service
public class UserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private InvitesMapper invitesMapper;
    // 注册业务
    public Map<String, Object> register(User user,String code) {
        Map<String, Object> result = new HashMap<>();

        // 参数校验
        if (!StringUtils.hasText(user.getUsername())){
            result.put("success", false);
            result.put("message", "用户名不能为空");
            return result;
        }

        if (!StringUtils.hasText(user.getPassword())) {
            result.put("success", false);
            result.put("message", "密码不能为空");
            return result;
        }

        // 检查用户名是否已存在
        if (userMapper.selectByUsername(user.getUsername()) != null) {
            result.put("success", false);
            result.put("message", "用户名已存在");
            return result;
        }

        // 检查邮箱是否已存在
        if (userMapper.selectByEmail(user.getEmail()) != null) {
            result.put("success", false);
            result.put("message", "邮箱已注册");
            return result;
        }
        //检查邀请码是否有效
        Invites invite= invitesMapper.selectByCode(code);
        if(invite==null){//邀请码不存在
            result.put("success", false);
            result.put("message","无效的邀请码");
            return result;
        }
        if(invite.getIsUsed()==1){//邀请码已被使用
            result.put("success", false);
            result.put("message","邀请码已被使用");
            return result;
        }
        //邮箱发送验证码验证
        //To do... ..
        //生成passkey
        SecureRandom random = new SecureRandom();
        user.setPasskey(String.valueOf(10000000 + random.nextInt(90000000)));
        // 保存用户
        userMapper.insert(user);
        invitesMapper.updateInviteByCode(code,user.getUsername());
        result.put("success", true);
        result.put("message", "注册成功");
        return result;
    }

    // 登录业务
    public Map<String, Object> login(String username, String password) {
        Map<String, Object> result = new HashMap<>();

        User user = userMapper.selectByUsername(username);//首先验证用户名
        if (user == null) {
            result.put("success", false);
            result.put("message", "用户不存在");
            return result;
        }

        //验证密码
        if(!password.equals(user.getPassword())){
            result.put("success", false);
            result.put("message","密码错误，请检查后重新输入");
            return result;
        }
        // 登录成功，返回用户信息(密码置空)
        user.setPassword(null);
        result.put("success", true);
        result.put("message", "登录成功");
        result.put("user", user);
        return result;
    }
    //更新用户等级
    public Map<String, Object> CalGrade(String username){
        Map<String, Object> result = new HashMap<>();
        //上传量+下载量0-500000 一级  510000-2000000 二级 2010000-3500000 三级 3510000-6500000 四级 6500000以上 五级
        User user = userMapper.selectByUsername(username);
        if(user.getUserUpload()+user.getUserDownload()<=500000*1024){
            user.setGradeId(1);
        }else if(user.getUserUpload()+user.getUserDownload()<=2000000*1024){
            user.setGradeId(2);
        }else if(user.getUserUpload()+user.getUserDownload()<= 3500000L *1024){
            user.setGradeId(3);
        }else if(user.getUserUpload()+user.getUserDownload()<= 6500000L *1024){
            user.setGradeId(4);
        }else{ user.setGradeId(5);}
        userMapper.updateGrade(username,user.getGradeId());
        result.put("success", true);
        result.put("message", "等级更新成功");
        result.put("grade", user.getGradeId());
        return result;
    }
    //设置性别
    public Map<String, Object> changesex(String username,String sex){
        Map<String, Object> result = new HashMap<>();
        userMapper.updatesex(username,sex);
        result.put("success", true);
        result.put("message", "性别设置成功");
        return result;
    }
    //设置头像
    public Map<String, Object> changeImage(String username,String image){
        Map<String, Object> result = new HashMap<>();
        userMapper.updateimage(username,image);
        result.put("success", true);
        result.put("message", "头像设置成功");
        return result;
    }
    //更改密码
    public Map<String, Object> changePassword(String username,String oldpassword,String newpassword){
        Map<String, Object> result = new HashMap<>();
        User user = userMapper.selectByUsername(username);//首先验证用户名
        if (user == null) {
            result.put("success", false);
            result.put("message", "用户不存在");
            return result;
        }

        //验证密码
        if(!oldpassword.equals(user.getPassword())){
            result.put("success", false);
            result.put("message","密码错误，请检查后重新输入");
            return result;
        }
        //更改数据库中的密码
        userMapper.updatePassword(username,newpassword);
        result.put("success", true);
        result.put("message", "密码重置成功");
        return result;
    }
}
