package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.Post;
import com.pt5.pthouduan.mapper.PostMapper;
import com.pt5.pthouduan.service.PostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  帖子服务实现类
 * </p>
 *
 * @author 杨蔓
 * @since 2025-04-14
 */
@Service
public class PostServiceImpl implements PostService {

    @Autowired
    private PostMapper postMapper;

    @Override
    public Post createPost(Post post) {
        postMapper.save(post);
        return post;
    }

    @Override
    public boolean deletePost(Integer postid) {
        return postMapper.deleteByPostid(postid) > 0;
    }

    @Override
    public boolean updatePost(Post post) {
        return postMapper.updatePost(post) > 0;
    }

    @Override
    public List<Post> searchPostsByKeyword(String keyword) {
        return postMapper.searchByKeyword(keyword);
    }

    @Override
    public boolean incrementLikes(Integer postid) {
        return postMapper.incrementLikes(postid) >= 0;
    }

    @Override
    public boolean decrementLikes(Integer postid) {
        return postMapper.decrementLikes(postid) >= 0;
    }

    @Override
    public boolean setPinnedStatus(Integer postid, boolean pinned) {
        return postMapper.updatePinnedStatus(postid, pinned) > 0;
    }

    @Override
    public List<Post> findByUserid(Long userid) {
        return postMapper.findByUserid(userid);
    }

    @Override
    public List<Post> findPinnedPosts() {
        return postMapper.findPinnedPosts();
    }

    /** ✅ 新增：获取所有帖子（置顶优先，时间倒序） */
    @Override
    public List<Post> getAllPostsSorted() {
        return postMapper.selectAllSorted();
    }
}
