package com.pt5.pthouduan.ControllerTest;



import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.ArgumentMatchers.anyInt;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentAddCreditControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void addCredit_WithValidParameters_ShouldReturnSuccess() throws Exception {
        // Arrange
        Long manageid = 1L;
        Long userid = 2L;
        Integer credit = 10;
        Long helpedId = 3L;

        // 模拟服务层调用成功
        doNothing().when(torrentService).addcredit(manageid, userid, credit);
        doNothing().when(torrentService).deducecredit(manageid, helpedId, credit);

        // Act & Assert
        mockMvc.perform(post("/torrent/addcredit")
                        .param("manageid", manageid.toString())
                        .param("userid", userid.toString())
                        .param("credit", credit.toString())
                        .param("helpedId", helpedId.toString()))
                .andExpect(status().isOk())
                .andExpect(content().string(credit.toString()));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).addcredit(manageid, userid, credit);
        verify(torrentService, times(1)).deducecredit(manageid, helpedId, credit);
    }

    @Test
    void addCredit_WhenAddCreditFails_ShouldReturnServerError() throws Exception {
        // Arrange
        Long manageid = 1L;
        Long userid = 2L;
        Integer credit = 10;
        Long helpedId = 3L;

        // 模拟addcredit抛出异常
        doThrow(new RuntimeException("Add credit failed")).when(torrentService).addcredit(manageid, userid, credit);
        // deducecredit不应该被调用
        doNothing().when(torrentService).deducecredit(anyLong(), anyLong(), anyInt());

        // Act & Assert
        mockMvc.perform(post("/torrent/addcredit")
                        .param("manageid", manageid.toString())
                        .param("userid", userid.toString())
                        .param("credit", credit.toString())
                        .param("helpedId", helpedId.toString()))
                .andExpect(status().isInternalServerError())
                .andExpect(jsonPath("$.success").value(false))
                .andExpect(jsonPath("$.message").value("服务器错误: Add credit failed"));

        // 验证服务层方法调用情况
        verify(torrentService, times(1)).addcredit(manageid, userid, credit);
        verify(torrentService, never()).deducecredit(anyLong(), anyLong(), anyInt());
    }

    @Test
    void addCredit_WhenDeduceCreditFails_ShouldReturnServerError() throws Exception {
        // Arrange
        Long manageid = 1L;
        Long userid = 2L;
        Integer credit = 10;
        Long helpedId = 3L;

        // 模拟addcredit成功
        doNothing().when(torrentService).addcredit(manageid, userid, credit);
        // 模拟deducecredit抛出异常
        doThrow(new RuntimeException("Deduce credit failed")).when(torrentService).deducecredit(manageid, helpedId, credit);

        // Act & Assert
        mockMvc.perform(post("/torrent/addcredit")
                        .param("manageid", manageid.toString())
                        .param("userid", userid.toString())
                        .param("credit", credit.toString())
                        .param("helpedId", helpedId.toString()))
                .andExpect(status().isInternalServerError())
                .andExpect(jsonPath("$.success").value(false))
                .andExpect(jsonPath("$.message").value("服务器错误: Deduce credit failed"));

        // 验证服务层方法调用情况
        verify(torrentService, times(1)).addcredit(manageid, userid, credit);
        verify(torrentService, times(1)).deducecredit(manageid, helpedId, credit);
    }

    @Test
    void addCredit_WithoutParameters_ShouldReturnBadRequest() throws Exception {
        // Act & Assert
        mockMvc.perform(post("/torrent/addcredit"))
                .andExpect(status().isBadRequest());
    }
}