package com.pt5.pthouduan.ControllerTest;


import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.entity.Torrent;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.*;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentListByCategoryWithFilterControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void getTorrentsByCategorywithFilter_WithCategoryAndFilters_ShouldReturnFilteredTorrents() throws Exception {
        // Arrange
        Integer categoryid = 1;
        Map<String, String> filters = new HashMap<>();
        filters.put("key1", "value1");
        filters.put("key2", "value2");

        Torrent torrent1 = new Torrent();
        Torrent torrent2 = new Torrent();
        List<Torrent> torrents = Arrays.asList(torrent1, torrent2);

        when(torrentService.getTorrentsByCategorywithfilters(categoryid, filters)).thenReturn(torrents);

        // Act & Assert
        mockMvc.perform(get("/torrent/listByCategorywithfilter")
                        .param("categoryid", categoryid.toString())
                        .param("key1", "value1")
                        .param("key2", "value2"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(2));
    }

    @Test
    void getTorrentsByCategorywithFilter_WithCategoryButNoFilters_ShouldReturnFilteredTorrents() throws Exception {
        // Arrange
        Integer categoryid = 1;
        Map<String, String> filters = new HashMap<>();

        Torrent torrent1 = new Torrent();
        Torrent torrent2 = new Torrent();
        List<Torrent> torrents = Arrays.asList(torrent1, torrent2);

        when(torrentService.getTorrentsByCategorywithfilters(categoryid, filters)).thenReturn(torrents);

        // Act & Assert
        mockMvc.perform(get("/torrent/listByCategorywithfilter")
                        .param("categoryid", categoryid.toString()))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(2));
    }

    @Test
    void getTorrentsByCategorywithFilter_WithNonExistingCategory_ShouldReturnEmptyList() throws Exception {
        // Arrange
        Integer categoryid = 999;
        Map<String, String> filters = new HashMap<>();
        filters.put("key1", "value1");

        when(torrentService.getTorrentsByCategorywithfilters(categoryid, filters)).thenReturn(Collections.emptyList());

        // Act & Assert
        mockMvc.perform(get("/torrent/listByCategorywithfilter")
                        .param("categoryid", categoryid.toString())
                        .param("key1", "value1"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(0));
    }
}
