package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import java.util.Map;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ljx
 * @since 2025-04-14
 */
@RestController
@RequestMapping("/user")
public class UserController {
    @Autowired
    private UserService userService;

    @PostMapping("/register")
    public Map<String, Object> register(@RequestBody User user,@RequestParam String code) {
        return userService.register(user,code);
    }

    @PostMapping("/login")
    public Map<String, Object> login(@RequestParam String username,
                                     @RequestParam String password) {
        return userService.login(username, password);
    }

    @PostMapping("/calgrade")
    public Map<String, Object> calgrade(@RequestParam String username) {
        return userService.CalGrade(username);
    }

    @PostMapping("/changesex")
    public Map<String, Object> changsex(@RequestParam String username,
                                        @RequestParam String sex) {
        return userService.changesex(username,sex);
    }

    @PostMapping("/changeimage")
    public Map<String, Object> changeimage(@RequestParam String username,
                                        @RequestParam String image) {
        return userService.changeImage(username,image);
    }

    @PostMapping("/changePassword")
    public Map<String, Object> changePassword(@RequestParam String username,
                                              @RequestParam String oldpassword,
                                              @RequestParam String newpassword) {
        return userService.changePassword(username,oldpassword,newpassword);
    }

    @GetMapping("/info")
    public Map<String, Object> getUserInfo(@RequestParam(required = false) String username) {
        return userService.login(username, "");
    }
}
