package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.User;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;


@Repository
public interface UserMapper extends BaseMapper<User> {
    @Insert("INSERT INTO user(username, password, email, passkey) VALUES(#{username}, #{password}, #{email}, #{passkey})")
    int insert(User user);

    @Select("SELECT * FROM User WHERE username = #{username}")
    User selectByUsername(String username);

    @Select("SELECT * FROM User WHERE email = #{email}")
    User selectByEmail(String email);

    @Update("UPDATE user SET password = #{password} WHERE username = #{username}")
    int updatePassword(@Param("username") String username, @Param("password") String password);

    @Update("UPDATE user SET sex = #{sex} WHERE username = #{username}")
    int updatesex(@Param("username") String username, @Param("sex") String sex);

    @Update("UPDATE user SET image = #{image} WHERE username = #{username}")
    int updateimage(@Param("username") String username, @Param("image") String image);

    @Update("UPDATE user SET gradeId = #{gradeId} WHERE username = #{username}")
    int updateGrade(@Param("username") String username, @Param("gradeId") Integer gradeId);
}
