/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import com.turn.ttorrent.bcodec.BDecoder;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.bcodec.InvalidBEncodingException;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentMetadataImpl;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TorrentParser {
    public TorrentMetadata parseFromFile(File torrentFile) throws IOException {
        byte[] fileContent = FileUtils.readFileToByteArray((File)torrentFile);
        return this.parse(fileContent);
    }

    public TorrentMetadata parse(byte[] metadata) throws InvalidBEncodingException, RuntimeException {
        byte[] infoTableBytes;
        Map<String, BEValue> dictionaryMetadata;
        try {
            dictionaryMetadata = BDecoder.bdecode(new ByteArrayInputStream(metadata)).getMap();
        }
        catch (InvalidBEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<String, BEValue> infoTable = this.getRequiredValueOrThrowException(dictionaryMetadata, "info").getMap();
        BEValue creationDateValue = dictionaryMetadata.get("creation date");
        long creationDate = creationDateValue == null ? -1L : creationDateValue.getLong();
        String comment = this.getStringOrNull(dictionaryMetadata, "comment");
        String createdBy = this.getStringOrNull(dictionaryMetadata, "created by");
        String announceUrl = this.getStringOrNull(dictionaryMetadata, "announce");
        List<List<String>> trackers = this.getTrackers(dictionaryMetadata);
        int pieceLength = this.getRequiredValueOrThrowException(infoTable, "piece length").getInt();
        byte[] piecesHashes = this.getRequiredValueOrThrowException(infoTable, "pieces").getBytes();
        boolean torrentContainsManyFiles = infoTable.get("files") != null;
        String dirName = this.getRequiredValueOrThrowException(infoTable, "name").getString();
        List<TorrentFile> files = this.parseFiles(infoTable, torrentContainsManyFiles, dirName);
        if (piecesHashes.length % 20 != 0) {
            throw new InvalidBEncodingException("Incorrect size of pieces hashes");
        }
        int piecesCount = piecesHashes.length / 20;
        try {
            infoTableBytes = BEncoder.bencode(infoTable).array();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new TorrentMetadataImpl(TorrentUtils.calculateSha1Hash(infoTableBytes), trackers, announceUrl, creationDate, comment, createdBy, dirName, files, piecesCount, pieceLength, piecesHashes);
    }

    private List<TorrentFile> parseFiles(Map<String, BEValue> infoTable, boolean torrentContainsManyFiles, String name) throws InvalidBEncodingException {
        if (!torrentContainsManyFiles) {
            BEValue md5Sum = infoTable.get("md5sum");
            return Collections.singletonList(new TorrentFile(Collections.singletonList(name), this.getRequiredValueOrThrowException(infoTable, "length").getLong(), md5Sum == null ? null : md5Sum.getString()));
        }
        ArrayList<TorrentFile> result = new ArrayList<TorrentFile>();
        for (BEValue file : infoTable.get("files").getList()) {
            Map<String, BEValue> fileInfo = file.getMap();
            ArrayList<String> path = new ArrayList<String>();
            BEValue filePathList = fileInfo.get("path.utf-8");
            if (filePathList == null) {
                filePathList = fileInfo.get("path");
            }
            for (BEValue pathElement : filePathList.getList()) {
                path.add(pathElement.getString());
            }
            BEValue md5Sum = infoTable.get("md5sum");
            result.add(new TorrentFile(path, fileInfo.get("length").getLong(), md5Sum == null ? null : md5Sum.getString()));
        }
        return result;
    }

    @Nullable
    private String getStringOrNull(Map<String, BEValue> dictionaryMetadata, String key) throws InvalidBEncodingException {
        BEValue value = dictionaryMetadata.get(key);
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    @Nullable
    private List<List<String>> getTrackers(Map<String, BEValue> dictionaryMetadata) throws InvalidBEncodingException {
        BEValue announceListValue = dictionaryMetadata.get("announce-list");
        if (announceListValue == null) {
            return null;
        }
        List<BEValue> announceList = announceListValue.getList();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        HashSet<String> allTrackers = new HashSet<String>();
        for (BEValue tv : announceList) {
            List<BEValue> trackers = tv.getList();
            if (trackers.isEmpty()) continue;
            ArrayList<String> tier = new ArrayList<String>();
            for (BEValue tracker : trackers) {
                String url = tracker.getString();
                if (allTrackers.contains(url)) continue;
                tier.add(url);
                allTrackers.add(url);
            }
            if (tier.isEmpty()) continue;
            result.add(tier);
        }
        return result;
    }

    @NotNull
    private BEValue getRequiredValueOrThrowException(Map<String, BEValue> map, String key) throws InvalidBEncodingException {
        BEValue value = map.get(key);
        if (value == null) {
            throw new InvalidBEncodingException("Invalid metadata format. Map doesn't contain required field " + key);
        }
        return value;
    }
}

