package com.pt5.pthouduan.entity;

import com.pt5.pthouduan.service.PasskeyValidator;
import com.pt5.pthouduan.service.UserService;
import com.turn.ttorrent.tracker.Tracker;
import com.turn.ttorrent.tracker.TorrentsRepository;
import com.turn.ttorrent.tracker.TrackerRequestProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;

@Service
public class TrackerInitializer {

    @Autowired
    private PasskeyValidator passkeyValidator;

    public Tracker createTracker() throws IOException {
        TorrentsRepository repository = new TorrentsRepository(1000);

        // 1. 创建自定义的Processor
        TrackerRequestProcessor processor = new PasskeyTrackerProcessor(
                repository,
                passkeyValidator
        );

        // 2. 使用四参数构造器
        Tracker tracker = new Tracker(
                6969,                       // 端口（与Nginx配置一致）
                "http://127.0.0.1/announce",  // 对外公告地址
                processor,                   // 自定义的Processor
                repository                   // Torrent仓库
        );
        tracker.setAnnounceInterval(100);

        tracker.setAcceptForeignTorrents(false); // 禁止未注册的种子
        return tracker;
    }
}
