package com.pt5.pthouduan.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.pt5.pthouduan.entity.Activity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 *  活动 Mapper 接口
 * </p>
 *
 * 功能：增、删、改、查（按是否展示）
 *
 * 作者：杨蔓
 * @since 2025-05-16
 */
@Mapper
public interface ActivityMapper extends BaseMapper<Activity> {

    // 根据是否展示状态查询活动列表（0：展示，1：隐藏）
    List<Activity> selectByIsShow(@Param("is_show") Integer isShow);

    // 插入新的活动
    int insert(Activity activity);

    // 根据活动ID删除活动
    int deleteById(@Param("activityid") Integer activityid);

    // 根据活动ID更新活动内容
    int updateById(Activity activity);

    // ✅ 新增：根据活动ID查询活动详情
    Activity selectById(@Param("activityid") Integer activityid);

}
