package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.Complain;
import com.pt5.pthouduan.mapper.ComplainMapper;
import com.pt5.pthouduan.service.ComplainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 投诉服务实现类
 * </p>
 *
 * 实现了投诉的增删改查逻辑
 *
 * @author ym
 * @since 2025-04-14
 */
@Service
public class ComplainServiceImpl implements ComplainService {

    @Autowired
    private ComplainMapper complainMapper;

    @Override
    public Complain createComplain(Complain complain) {
        complainMapper.save(complain);
        return complain;
    }

    @Override
    public boolean deleteComplain(Integer complainid) {
        return complainMapper.deleteByComplainid(complainid) > 0;
    }

    @Override
    public boolean updateComplain(Complain complain) {
        return complainMapper.updateComplain(complain) > 0;
    }

    @Override
    public List<Complain> getComplainsByTargetUser(Long duser) {
        return complainMapper.selectByDuser(duser);
    }

    @Override
    public List<Complain> getComplainsByPostingUser(Long puse) {
        return complainMapper.selectByPuse(puse);
    }

    @Override
    public List<Complain> getAllComplains() {
        return complainMapper.selectList(null); // 查询全部记录
    }

    @Override
    public Complain getComplainById(Integer complainid) {
        return complainMapper.selectById(complainid); // 根据主键查记录
    }


}
