package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.CategoryController;
import com.pt5.pthouduan.entity.Category;
import com.pt5.pthouduan.service.CategoryService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.Arrays;
import java.util.List;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

public class CategoryControllerTest {

    private MockMvc mockMvc;

    @Mock
    private CategoryService categoryService;

    @InjectMocks
    private CategoryController categoryController;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(categoryController).build();
    }

    @Test
    public void testGetAllCategories() throws Exception {
        // 准备模拟数据
        Category category1 = new Category();
        category1.setCategoryid(1);
        category1.setCategory_name("电子产品");

        Category category2 = new Category();
        category2.setCategoryid(2);
        category2.setCategory_name("服装");

        List<Category> categories = Arrays.asList(category1, category2);

        // 模拟 service 行为
        when(categoryService.getAllCategories()).thenReturn(categories);

        // 执行请求并验证结果
        mockMvc.perform(get("/categories"))
                .andExpect(status().isOk());
    }
}
