package com.pt5.pthouduan.ControllerTest;


import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.mapper.UserMapper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentUsernameControllerTest {

    @Mock
    private UserMapper userMapper;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void getUsernameByUserId_ExistingUser_ShouldReturnUsername() throws Exception {
        // Arrange
        Long userId = 1L;
        String expectedUsername = "testuser";

        when(userMapper.selectUsernameByUserid(userId)).thenReturn(expectedUsername);

        // Act & Assert
        mockMvc.perform(get("/torrent/{userId}/username", userId))
                .andExpect(status().isOk())
                .andExpect(content().string(expectedUsername));

        // 验证userMapper方法被调用
        verify(userMapper, times(1)).selectUsernameByUserid(userId);
    }

    @Test
    void getUsernameByUserId_NonExistingUser_ShouldReturnNotFound() throws Exception {
        // Arrange
        Long userId = 999L;

        when(userMapper.selectUsernameByUserid(userId)).thenReturn(null);

        // Act & Assert
        mockMvc.perform(get("/torrent/{userId}/username", userId))
                .andExpect(status().isNotFound());

        // 验证userMapper方法被调用
        verify(userMapper, times(1)).selectUsernameByUserid(userId);
    }

    @Test
    void getUsernameByUserId_WhenDatabaseErrorOccurs_ShouldReturnInternalServerError() throws Exception {
        // Arrange
        Long userId = 1L;

        when(userMapper.selectUsernameByUserid(userId)).thenThrow(new RuntimeException("Database connection failed"));

        // Act & Assert
        mockMvc.perform(get("/torrent/{userId}/username", userId))
                .andExpect(status().isInternalServerError());

        // 验证userMapper方法被调用
        verify(userMapper, times(1)).selectUsernameByUserid(userId);
    }

    @Test
    void getUsernameByUserId_WithoutUserIdParameter_ShouldReturnBadRequest() throws Exception {
        // Act & Assert
        mockMvc.perform(get("/torrent//username")) // 故意不提供userId
                .andExpect(status().isBadRequest());
    }
}