package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.ChatInformation;
import com.pt5.pthouduan.service.ChatInformationService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

class ChatInformationControllerTest {

    @Mock
    private ChatInformationService chatInformationService;

    @InjectMocks
    private ChatInformationController chatInformationController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void createChat_ShouldReturnSavedChat() {
        ChatInformation chat = new ChatInformation();
        chat.setSenderId(1L);
        chat.setReceiverId(2L);
        chat.setContent("Hello");
        chat.setTalkTime(LocalDateTime.now());

        when(chatInformationService.createChat(any(ChatInformation.class))).thenReturn(chat);

        ChatInformation result = chatInformationController.createChat(chat);

        assertNotNull(result);
        assertEquals("Hello", result.getContent());
        verify(chatInformationService).createChat(any(ChatInformation.class));
    }

    @Test
    void deleteChat_ShouldReturnSuccessMessage_WhenDeleted() {
        when(chatInformationService.deleteChatById(1)).thenReturn(true);

        String result = chatInformationController.deleteChat(1);

        assertEquals("删除成功", result);
        verify(chatInformationService).deleteChatById(1);
    }

    @Test
    void deleteChat_ShouldReturnFailureMessage_WhenNotDeleted() {
        when(chatInformationService.deleteChatById(99)).thenReturn(false);

        String result = chatInformationController.deleteChat(99);

        assertEquals("删除失败", result);
        verify(chatInformationService).deleteChatById(99);
    }

    @Test
    void getChatsByUser_ShouldReturnChatList() {
        ChatInformation chat1 = new ChatInformation();
        chat1.setSenderId(1L);
        chat1.setReceiverId(2L);
        chat1.setContent("Hi");

        ChatInformation chat2 = new ChatInformation();
        chat2.setSenderId(2L);
        chat2.setReceiverId(1L);
        chat2.setContent("Hello");

        when(chatInformationService.getChatsByUser(1L)).thenReturn(Arrays.asList(chat1, chat2));

        List<ChatInformation> result = chatInformationController.getChatsByUser(1L);

        assertEquals(2, result.size());
        assertEquals("Hi", result.get(0).getContent());
    }

    @Test
    void getChatsBetweenUsers_ShouldReturnChatListBetweenTwoUsers() {
        ChatInformation chat = new ChatInformation();
        chat.setSenderId(1L);
        chat.setReceiverId(2L);
        chat.setContent("Hey");

        when(chatInformationService.getChatsBetweenUsers(1L, 2L)).thenReturn(List.of(chat));

        List<ChatInformation> result = chatInformationController.getChatsBetweenUsers(1L, 2L);

        assertEquals(1, result.size());
        assertEquals("Hey", result.get(0).getContent());
    }
}
