package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.Comment;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 *  评论 Mapper 接口
 * </p>
 *
 * 功能：增、删、改、查（按帖子ID）
 *
 * @author ym
 * @since 2025-04-14
 */
@Mapper
public interface CommentMapper extends BaseMapper<Comment> {

    // 创建评论
    void save(Comment comment);

    // 根据评论ID删除
    int deleteByCommentid(@Param("commentid") Integer commentid);

    // 更新评论
    int updateComment(Comment comment);

    // 获取指定帖子下的所有评论
    List<Comment> selectByPostid(@Param("postid") Integer postid);

    // 点赞 +1
    int incrementLikes(@Param("commentid") Integer commentid);

    // 取消点赞 -1（最小为0）
    int decrementLikes(@Param("commentid") Integer commentid);

}
