package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.Complain;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 投诉 Mapper 接口
 * </p>
 *
 * 功能：增、删、改、查（按被投诉用户ID和投诉发起人ID）
 *
 * @author ym
 * @since 2025-04-14
 */
@Mapper
public interface ComplainMapper extends BaseMapper<Complain> {

    // 创建投诉
    void save(Complain complain);

    // 根据投诉ID删除
    int deleteByComplainid(@Param("complainid") Integer complainid);

    // 更新投诉
    int updateComplain(Complain complain);

    // 根据被投诉用户ID查询投诉列表
    List<Complain> selectByDuser(@Param("duser") Long duser);

    // 根据投诉发起人ID查询投诉列表
    List<Complain> selectByPuse(@Param("puse") Long puse);

    // 根据投诉ID查询投诉记录
    Complain selectByComplainId(@Param("complainid") Integer complainid);

    // 获取所有投诉记录
    List<Complain> selectAllComplains();


}
