package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.FriendsList;

import java.util.List;

/**
 * <p>
 *  好友关系服务接口
 * </p>
 *
 * 功能：
 *  - 发起好友申请（待确认）
 *  - 同意好友申请（状态变更）
 *  - 删除好友
 *  - 查询用户所有已通过好友
 *  - 查询用户所有待确认好友请求
 *
 * @author 杨蔓
 * @since 2025-04-14
 */
public interface FriendsListService {

    boolean addFriend(FriendsList friendsList);              // 发起好友申请

    boolean acceptFriend(Long friend1, Long friend2);        // 同意好友申请（状态设为 accepted）

    boolean deleteFriendByFriends(Long friend1, Long friend2); // 删除好友关系

    List<FriendsList> getAcceptedFriendsByUserId(Long userid); // 查询某用户的所有已通过好友

    List<FriendsList> getPendingRequests(Long userid);         // 查询待确认好友请求（自己是 friend2）
}
