package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.Comment;
import com.pt5.pthouduan.mapper.CommentMapper;
import com.pt5.pthouduan.service.CommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 评论服务实现类
 * </p>
 *
 * 实现了评论的增删改查逻辑
 *
 * @author ym
 * @since 2025-04-14
 */
@Service
public class CommentServiceImpl implements CommentService {

    @Autowired
    private CommentMapper commentMapper;

    @Override
    public Comment createComment(Comment comment) {
        commentMapper.save(comment);
        return comment;
    }

    @Override
    public boolean deleteComment(Integer commentid) {
        return commentMapper.deleteByCommentid(commentid) > 0;
    }

    @Override
    public boolean updateComment(Comment comment) {
        return commentMapper.updateComment(comment) > 0;
    }

    @Override
    public List<Comment> getCommentsByPostId(Integer postid) {
        return commentMapper.selectByPostid(postid);
    }


    @Override
    public boolean likeComment(Integer commentid) {
        return commentMapper.incrementLikes(commentid) > 0;
    }

    @Override
    public boolean unlikeComment(Integer commentid) {
        return commentMapper.decrementLikes(commentid) > 0;

    }


}
