package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.service.PasskeyValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

// 示例实现（使用Spring JDBC）
@Service
public class DatabasePasskeyValidator implements PasskeyValidator {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public boolean isValid(String passkey) {
        String sql = "SELECT COUNT(*) FROM user WHERE passkey = ?";
        int count = jdbcTemplate.queryForObject(sql, Integer.class, passkey);
        return count > 0;
    }
}