package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.FriendsList;
import com.pt5.pthouduan.mapper.FriendsListMapper;
import com.pt5.pthouduan.service.FriendsListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  好友服务实现类
 * </p>
 *
 * 功能：
 *  - 发起好友申请
 *  - 同意好友请求
 *  - 删除好友
 *  - 查询所有好友
 *  - 查询所有待同意请求
 *
 * @author 杨蔓
 * @since 2025-04-14
 */
@Service
public class FriendsListServiceImpl implements FriendsListService {

    @Autowired
    private FriendsListMapper friendsListMapper;

    /** 发起好友申请（status = pending） */
    @Override
    public boolean addFriend(FriendsList friendsList) {
        return friendsListMapper.insertFriendRequest(friendsList) > 0;
    }

    /** 同意好友申请（更新 status = accepted） */
    @Override
    public boolean acceptFriend(Long friend1, Long friend2) {
        return friendsListMapper.updateFriendStatus(friend1, friend2, "accepted") > 0;
    }

    /** 删除好友（无论谁是 friend1 或 friend2） */
    @Override
    public boolean deleteFriendByFriends(Long friend1, Long friend2) {
        return friendsListMapper.deleteByFriendPair(friend1, friend2) > 0;
    }

    /** 查询某用户所有已通过的好友 */
    @Override
    public List<FriendsList> getAcceptedFriendsByUserId(Long userid) {
        return friendsListMapper.selectAcceptedFriends(userid);
    }

    /** 查询所有待同意的好友申请（自己是 friend2 且 status = pending） */
    @Override
    public List<FriendsList> getPendingRequests(Long userid) {
        return friendsListMapper.selectPendingRequests(userid);
    }
}
