package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.Complain;
import com.pt5.pthouduan.service.ComplainService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

class ComplainControllerTest {

    @Mock
    private ComplainService complainService;

    @InjectMocks
    private ComplainController complainController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void createComplain_ShouldReturnCreatedComplain() {
        Complain complain = new Complain();
        complain.setComplainid(1);
        complain.setPuse(100L);
        complain.setDuser(200L);
        complain.setContent("Bad behavior");
        complain.setTorrentid(123L);

        when(complainService.createComplain(any(Complain.class))).thenReturn(complain);

        Complain result = complainController.createComplain(complain);

        assertEquals("Bad behavior", result.getContent());
        assertEquals(100L, result.getPuse());
        verify(complainService).createComplain(any(Complain.class));
    }

    @Test
    void deleteComplain_ShouldReturnTrue_WhenDeleted() {
        when(complainService.deleteComplain(1)).thenReturn(true);

        boolean result = complainController.deleteComplain(1);

        assertTrue(result);
        verify(complainService).deleteComplain(1);
    }

    @Test
    void updateComplain_ShouldReturnTrue_WhenUpdated() {
        Complain complain = new Complain();
        complain.setComplainid(1);
        complain.setContent("Updated complaint");

        when(complainService.updateComplain(any(Complain.class))).thenReturn(true);

        boolean result = complainController.updateComplain(complain);

        assertTrue(result);
        verify(complainService).updateComplain(complain);
    }

    @Test
    void getComplainsByTargetUser_ShouldReturnList() {
        Complain c1 = new Complain();
        c1.setDuser(200L);
        c1.setContent("Cheating");

        when(complainService.getComplainsByTargetUser(200L)).thenReturn(List.of(c1));

        List<Complain> result = complainController.getComplainsByTargetUser(200L);

        assertEquals(1, result.size());
        assertEquals("Cheating", result.get(0).getContent());
    }

    @Test
    void getComplainsByPostingUser_ShouldReturnList() {
        Complain c = new Complain();
        c.setPuse(100L);
        c.setContent("Spam complaint");

        when(complainService.getComplainsByPostingUser(100L)).thenReturn(List.of(c));

        List<Complain> result = complainController.getComplainsByPostingUser(100L);

        assertEquals(1, result.size());
        assertEquals("Spam complaint", result.get(0).getContent());
    }

    @Test
    void getAllComplains_ShouldReturnAll() {
        Complain c1 = new Complain();
        c1.setContent("Complain A");
        Complain c2 = new Complain();
        c2.setContent("Complain B");

        when(complainService.getAllComplains()).thenReturn(Arrays.asList(c1, c2));

        List<Complain> result = complainController.getAllComplains();

        assertEquals(2, result.size());
        assertEquals("Complain A", result.get(0).getContent());
        assertEquals("Complain B", result.get(1).getContent());
    }

    @Test
    void getComplainInfo_ShouldReturnComplainDetails() {
        Complain c = new Complain();
        c.setComplainid(1);
        c.setPuse(100L);
        c.setDuser(200L);
        c.setTorrentid(500L);

        when(complainService.getComplainById(1)).thenReturn(c);

        Complain result = complainController.getComplainInfo(1);

        assertEquals(100L, result.getPuse());
        assertEquals(200L, result.getDuser());
        assertEquals(500L, result.getTorrentid());
    }
}
