/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network;

import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.TimeService;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.network.AcceptAttachmentImpl;
import com.turn.ttorrent.network.ConnectTask;
import com.turn.ttorrent.network.ConnectionManagerContext;
import com.turn.ttorrent.network.ConnectionWorker;
import com.turn.ttorrent.network.NewConnectionAllower;
import com.turn.ttorrent.network.SelectorFactory;
import com.turn.ttorrent.network.ServerChannelRegister;
import com.turn.ttorrent.network.TimeoutStorage;
import com.turn.ttorrent.network.TimeoutStorageImpl;
import com.turn.ttorrent.network.WriteTask;
import com.turn.ttorrent.network.keyProcessors.AcceptableKeyProcessor;
import com.turn.ttorrent.network.keyProcessors.CleanupKeyProcessor;
import com.turn.ttorrent.network.keyProcessors.ConnectableKeyProcessor;
import com.turn.ttorrent.network.keyProcessors.InvalidKeyProcessor;
import com.turn.ttorrent.network.keyProcessors.ReadableKeyProcessor;
import com.turn.ttorrent.network.keyProcessors.WritableKeyProcessor;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ConnectionManager {
    private static final Logger logger = TorrentLoggerFactory.getLogger(ConnectionManager.class);
    private final Selector selector;
    private final TimeService myTimeService;
    private volatile ConnectionWorker myConnectionWorker;
    private int myBindPort;
    private final ConnectionManagerContext myContext;
    private volatile ServerSocketChannel myServerSocketChannel;
    private volatile Future<?> myWorkerFuture;
    private final NewConnectionAllower myIncomingConnectionAllower;
    private final NewConnectionAllower myOutgoingConnectionAllower;
    private final TimeoutStorage socketTimeoutStorage = new TimeoutStorageImpl();
    private final AtomicBoolean alreadyInit = new AtomicBoolean(false);
    private final AtomicInteger mySendBufferSize;
    private final AtomicInteger myReceiveBufferSize;

    public ConnectionManager(ConnectionManagerContext context, TimeService timeService, NewConnectionAllower newIncomingConnectionAllower, NewConnectionAllower newOutgoingConnectionAllower, SelectorFactory selectorFactory, AtomicInteger mySendBufferSize, AtomicInteger myReceiveBufferSize) throws IOException {
        this.mySendBufferSize = mySendBufferSize;
        this.myReceiveBufferSize = myReceiveBufferSize;
        this.selector = selectorFactory.newSelector();
        this.myTimeService = timeService;
        this.myContext = context;
        this.myIncomingConnectionAllower = newIncomingConnectionAllower;
        this.myOutgoingConnectionAllower = newOutgoingConnectionAllower;
    }

    public void initAndRunWorker(ServerChannelRegister serverChannelRegister) throws IOException {
        boolean wasInit = this.alreadyInit.getAndSet(true);
        if (wasInit) {
            throw new IllegalStateException("connection manager was already initialized");
        }
        this.myServerSocketChannel = serverChannelRegister.channelFor(this.selector);
        this.myServerSocketChannel.register(this.selector, 16, new AcceptAttachmentImpl(this.myContext));
        this.myBindPort = this.myServerSocketChannel.socket().getLocalPort();
        String serverName = this.myServerSocketChannel.socket().toString();
        this.myConnectionWorker = new ConnectionWorker(this.selector, Arrays.asList(new InvalidKeyProcessor(), new AcceptableKeyProcessor(this.selector, serverName, this.myTimeService, this.myIncomingConnectionAllower, this.socketTimeoutStorage, this.mySendBufferSize, this.myReceiveBufferSize), new ConnectableKeyProcessor(this.selector, this.myTimeService, this.socketTimeoutStorage, this.mySendBufferSize, this.myReceiveBufferSize), new ReadableKeyProcessor(serverName), new WritableKeyProcessor()), 10000, 120000, this.myTimeService, new CleanupKeyProcessor(this.myTimeService), this.myOutgoingConnectionAllower);
        this.myWorkerFuture = this.myContext.getExecutor().submit(this.myConnectionWorker);
    }

    public void setSelectorSelectTimeout(int timeout) {
        ConnectionWorker workerLocal = this.myConnectionWorker;
        this.checkThatWorkerIsInit(workerLocal);
        workerLocal.setSelectorSelectTimeout(timeout);
    }

    private void checkThatWorkerIsInit(ConnectionWorker worker) {
        if (worker == null) {
            throw new IllegalStateException("Connection manager is not initialized!");
        }
    }

    public boolean offerConnect(ConnectTask connectTask, int timeout, TimeUnit timeUnit) {
        if (this.myConnectionWorker == null) {
            return false;
        }
        return this.myConnectionWorker.offerConnect(connectTask, timeout, timeUnit);
    }

    public boolean offerWrite(WriteTask writeTask, int timeout, TimeUnit timeUnit) {
        if (this.myConnectionWorker == null) {
            return false;
        }
        return this.myConnectionWorker.offerWrite(writeTask, timeout, timeUnit);
    }

    public int getBindPort() {
        return this.myBindPort;
    }

    public void close(int timeout, TimeUnit timeUnit) {
        logger.debug("try close connection manager...");
        boolean successfullyClosed = true;
        if (this.myConnectionWorker != null) {
            this.myWorkerFuture.cancel(true);
            try {
                boolean shutdownCorrectly = this.myConnectionWorker.stop(timeout, timeUnit);
                if (!shutdownCorrectly) {
                    successfullyClosed = false;
                    logger.warn("unable to terminate worker in {} {}", (Object)timeout, (Object)timeUnit);
                }
            }
            catch (InterruptedException e) {
                successfullyClosed = false;
                LoggerUtils.warnAndDebugDetails(logger, "unable to await termination worker, thread was interrupted", e);
            }
        }
        try {
            this.myServerSocketChannel.close();
        }
        catch (Throwable e) {
            LoggerUtils.errorAndDebugDetails(logger, "unable to close server socket channel", e);
            successfullyClosed = false;
        }
        for (SelectionKey key : this.selector.keys()) {
            try {
                if (!key.isValid()) continue;
                key.channel().close();
            }
            catch (Throwable e) {
                logger.error("unable to close socket channel {}", (Object)key.channel());
                successfullyClosed = false;
                logger.debug("", e);
            }
        }
        try {
            this.selector.close();
        }
        catch (Throwable e) {
            LoggerUtils.errorAndDebugDetails(logger, "unable to close selector channel", e);
            successfullyClosed = false;
        }
        if (successfullyClosed) {
            logger.debug("connection manager is successfully closed");
        } else {
            logger.error("connection manager wasn't closed successfully");
        }
    }

    public void close() {
        this.close(1, TimeUnit.MINUTES);
    }

    public void setCleanupTimeout(long timeoutMillis) {
        ConnectionWorker workerLocal = this.myConnectionWorker;
        this.checkThatWorkerIsInit(workerLocal);
        workerLocal.setCleanupTimeout(timeoutMillis);
    }

    public void setSocketConnectionTimeout(long timeoutMillis) {
        this.socketTimeoutStorage.setTimeout(timeoutMillis);
    }

    public void closeChannel(Channel channel) throws IOException {
        channel.close();
    }
}

