/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network.keyProcessors;

import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.TimeService;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.network.TimeoutAttachment;
import com.turn.ttorrent.network.keyProcessors.CleanupProcessor;
import com.turn.ttorrent.network.keyProcessors.KeyProcessorUtil;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;

public class CleanupKeyProcessor
implements CleanupProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(CleanupKeyProcessor.class);
    private final TimeService myTimeService;

    public CleanupKeyProcessor(TimeService timeService) {
        this.myTimeService = timeService;
    }

    @Override
    public void processCleanup(SelectionKey key) {
        TimeoutAttachment attachment = KeyProcessorUtil.getAttachmentAsTimeoutOrNull(key);
        if (attachment == null) {
            key.cancel();
            return;
        }
        if (attachment.isTimeoutElapsed(this.myTimeService.now())) {
            SocketChannel channel = KeyProcessorUtil.getCastedChannelOrNull(key);
            if (channel == null) {
                key.cancel();
                return;
            }
            logger.debug("channel {} was inactive in specified timeout. Close channel...", (Object)channel);
            try {
                channel.close();
                key.cancel();
                attachment.onTimeoutElapsed(channel);
            }
            catch (IOException e) {
                LoggerUtils.errorAndDebugDetails(logger, "unable close channel {}", channel, e);
            }
        }
    }

    @Override
    public void processSelected(SelectionKey key) {
        TimeoutAttachment attachment = KeyProcessorUtil.getAttachmentAsTimeoutOrNull(key);
        if (attachment == null) {
            key.cancel();
            return;
        }
        attachment.communicatedNow(this.myTimeService.now());
    }
}

