/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network.keyProcessors;

import com.turn.ttorrent.common.TimeService;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.network.ConnectTask;
import com.turn.ttorrent.network.ConnectionListener;
import com.turn.ttorrent.network.ReadWriteAttachment;
import com.turn.ttorrent.network.TimeoutStorage;
import com.turn.ttorrent.network.keyProcessors.KeyProcessor;
import com.turn.ttorrent.network.keyProcessors.KeyProcessorUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ConnectableKeyProcessor
implements KeyProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(ConnectableKeyProcessor.class);
    private final Selector mySelector;
    private final TimeService myTimeService;
    private final TimeoutStorage myTimeoutStorage;
    private final AtomicInteger mySendBufferSize;
    private final AtomicInteger myReceiveBufferSize;

    public ConnectableKeyProcessor(Selector selector, TimeService timeService, TimeoutStorage timeoutStorage, AtomicInteger sendBufferSize, AtomicInteger receiveBufferSize) {
        this.mySelector = selector;
        this.myTimeService = timeService;
        this.myTimeoutStorage = timeoutStorage;
        this.mySendBufferSize = sendBufferSize;
        this.myReceiveBufferSize = receiveBufferSize;
    }

    @Override
    public void process(SelectionKey key) throws IOException {
        boolean isConnectFinished;
        SelectableChannel channel = key.channel();
        if (!(channel instanceof SocketChannel)) {
            logger.warn("incorrect instance of channel. The key is cancelled");
            key.cancel();
            return;
        }
        SocketChannel socketChannel = (SocketChannel)channel;
        Object attachment = key.attachment();
        if (!(attachment instanceof ConnectTask)) {
            logger.warn("incorrect instance of attachment for channel {}. The key for the channel is cancelled", (Object)socketChannel);
            key.cancel();
            return;
        }
        ConnectTask connectTask = (ConnectTask)attachment;
        ConnectionListener connectionListener = connectTask.getConnectionListener();
        try {
            isConnectFinished = socketChannel.finishConnect();
        }
        catch (NoRouteToHostException e) {
            logger.info("Could not connect to {}:{}, received NoRouteToHostException", (Object)connectTask.getHost(), (Object)connectTask.getPort());
            connectionListener.onError(socketChannel, e);
            return;
        }
        catch (ConnectException e) {
            logger.info("Could not connect to {}:{}, received ConnectException", (Object)connectTask.getHost(), (Object)connectTask.getPort());
            connectionListener.onError(socketChannel, e);
            return;
        }
        if (!isConnectFinished) {
            logger.info("Could not connect to {}:{}", (Object)connectTask.getHost(), (Object)connectTask.getPort());
            connectionListener.onError(socketChannel, null);
            return;
        }
        socketChannel.configureBlocking(false);
        KeyProcessorUtil.setBuffersSizeIfNecessary(socketChannel, this.mySendBufferSize.get(), this.myReceiveBufferSize.get());
        ReadWriteAttachment keyAttachment = new ReadWriteAttachment(connectionListener, this.myTimeService.now(), this.myTimeoutStorage.getTimeoutMillis());
        socketChannel.register(this.mySelector, 1, keyAttachment);
        logger.debug("setup new TCP connection with {}", (Object)socketChannel);
        connectionListener.onConnectionEstablished(socketChannel);
    }

    @Override
    public boolean accept(SelectionKey key) {
        return key.isValid() && key.isConnectable();
    }
}

