/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.creation;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentParser;
import com.turn.ttorrent.common.creation.DataSourceHolder;
import com.turn.ttorrent.common.creation.HashingResult;
import com.turn.ttorrent.common.creation.PiecesHashesCalculator;
import com.turn.ttorrent.common.creation.SingleThreadHashesCalculator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MetadataBuilder {
    private static final Logger logger = TorrentLoggerFactory.getLogger(MetadataBuilder.class);
    private static final String DEFAULT_CREATED_BY = "ttorrent library";
    @NotNull
    private String announce = "";
    @NotNull
    private List<List<String>> announceList = new ArrayList<List<String>>();
    private long creationDate = -1L;
    @NotNull
    private String comment = "";
    @NotNull
    private String createdBy = "ttorrent library";
    @NotNull
    private List<String> webSeedUrlList = new ArrayList<String>();
    private int pieceLength = 524288;
    private boolean isPrivate = false;
    @NotNull
    private List<String> filesPaths = new ArrayList<String>();
    @Nullable
    private HashingResult hashingResult = null;
    @NotNull
    private List<DataSourceHolder> dataSources = new ArrayList<DataSourceHolder>();
    @NotNull
    private String directoryName = "";
    @NotNull
    private PiecesHashesCalculator piecesHashesCalculator = new SingleThreadHashesCalculator();

    public MetadataBuilder setTracker(String announce) {
        this.announce = announce;
        return this;
    }

    public MetadataBuilder addTracker(String url) {
        this.initFirstTier();
        this.announceList.get(this.announceList.size() - 1).add(url);
        return this;
    }

    public MetadataBuilder addTrackers(Collection<String> trackers) {
        this.initFirstTier();
        this.announceList.get(this.announceList.size() - 1).addAll(trackers);
        return this;
    }

    public MetadataBuilder newTier() {
        this.announceList.add(new ArrayList());
        return this;
    }

    public MetadataBuilder addWebSeedUrl(String url) {
        this.webSeedUrlList.add(url);
        return this;
    }

    public MetadataBuilder setCreationTime(int creationTime) {
        this.creationDate = creationTime;
        return this;
    }

    public MetadataBuilder setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public MetadataBuilder setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public MetadataBuilder setPiecesHashesCalculator(@NotNull PiecesHashesCalculator piecesHashesCalculator) {
        this.piecesHashesCalculator = piecesHashesCalculator;
        return this;
    }

    public MetadataBuilder setPieceLength(int pieceLength) {
        this.pieceLength = pieceLength;
        return this;
    }

    public MetadataBuilder setDirectoryName(@NotNull String directoryName) {
        this.directoryName = directoryName;
        return this;
    }

    public MetadataBuilder addDataSource(@NotNull InputStream dataSource, String path, boolean closeAfterBuild) {
        this.checkHashingResultIsNotSet();
        this.filesPaths.add(path);
        this.dataSources.add(new StreamBasedHolderImpl(dataSource, closeAfterBuild));
        return this;
    }

    public MetadataBuilder addDataSource(@NotNull InputStream dataSource, String path) {
        this.addDataSource(dataSource, path, true);
        return this;
    }

    public MetadataBuilder addFile(@NotNull File source, @NotNull String path) {
        if (!source.isFile()) {
            throw new IllegalArgumentException(source + " is not exist");
        }
        this.checkHashingResultIsNotSet();
        this.filesPaths.add(path);
        this.dataSources.add(new FileSourceHolder(source));
        return this;
    }

    private void checkHashingResultIsNotSet() {
        if (this.hashingResult != null) {
            throw new IllegalStateException("Unable to add new source when hashes are set manually");
        }
    }

    public MetadataBuilder addFile(@NotNull File source) {
        return this.addFile(source, source.getName());
    }

    public MetadataBuilder setFilesInfo(@NotNull List<byte[]> hashes, @NotNull List<String> filesPaths, @NotNull List<Long> filesLengths) {
        if (this.dataSources.size() != 0) {
            throw new IllegalStateException("Unable to add hashes-based files info. Some data sources already added");
        }
        this.filesPaths.clear();
        this.filesPaths.addAll(filesPaths);
        this.hashingResult = new HashingResult(hashes, filesLengths);
        return this;
    }

    public void doPrivate() {
        this.isPrivate = true;
    }

    public void doPublic() {
        this.isPrivate = false;
    }

    public TorrentMetadata build() throws IOException {
        return new TorrentParser().parse(this.buildBinary());
    }

    public byte[] buildBinary() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BEncoder.bencode(this.buildBEP(), (OutputStream)out);
        return out.toByteArray();
    }

    public BEValue buildBEP() throws IOException {
        return this.buildAndCloseResources();
    }

    private BEValue buildAndCloseResources() throws IOException {
        try {
            BEValue bEValue = this.doBuild();
            return bEValue;
        }
        finally {
            this.closeAllSources();
        }
    }

    private BEValue doBuild() throws IOException {
        String name;
        boolean isSingleMode;
        this.dropEmptyTiersFromAnnounce();
        if (this.announce.isEmpty() && !this.announceList.isEmpty()) {
            this.announce = this.announceList.get(0).get(0);
        }
        if (this.filesPaths.size() == 0) {
            throw new IllegalStateException("Unable to create metadata without sources. Use addSource() method for adding sources");
        }
        boolean bl = isSingleMode = this.filesPaths.size() == 1 && this.directoryName.isEmpty();
        if (!this.directoryName.isEmpty()) {
            name = this.directoryName;
        } else if (isSingleMode) {
            name = this.filesPaths.get(0);
        } else {
            throw new IllegalStateException("Missing required field 'name'. Use setDirectoryName() method for specifying name of torrent");
        }
        HashMap<String, BEValue> torrent = new HashMap<String, BEValue>();
        if (!this.announce.isEmpty()) {
            torrent.put("announce", new BEValue(this.announce));
        }
        if (!this.announceList.isEmpty()) {
            torrent.put("announce-list", this.wrapAnnounceList());
        }
        if (this.creationDate > 0L) {
            torrent.put("creation date", new BEValue(this.creationDate));
        }
        if (!this.comment.isEmpty()) {
            torrent.put("comment", new BEValue(this.comment));
        }
        if (!this.createdBy.isEmpty()) {
            torrent.put("created by", new BEValue(this.createdBy));
        }
        if (!this.webSeedUrlList.isEmpty()) {
            torrent.put("url-list", this.wrapStringList(this.webSeedUrlList));
        }
        HashingResult hashingResult = this.hashingResult == null ? this.piecesHashesCalculator.calculateHashes(this.dataSources, this.pieceLength) : this.hashingResult;
        HashMap<String, BEValue> info = new HashMap<String, BEValue>();
        info.put("piece length", new BEValue(this.pieceLength));
        info.put("pieces", this.concatHashes(hashingResult.getHashes()));
        info.put("private", new BEValue(this.isPrivate ? 1 : 0));
        info.put("name", new BEValue(name));
        if (isSingleMode) {
            Long sourceSize = hashingResult.getSourceSizes().get(0);
            info.put("length", new BEValue(sourceSize));
        } else {
            List<BEValue> files = this.getFilesList(hashingResult);
            info.put("files", new BEValue(files));
        }
        torrent.put("info", new BEValue(info));
        return new BEValue(torrent);
    }

    private List<BEValue> getFilesList(HashingResult hashingResult) throws UnsupportedEncodingException {
        ArrayList<BEValue> result = new ArrayList<BEValue>();
        for (int i = 0; i < this.filesPaths.size(); ++i) {
            HashMap<String, BEValue> file = new HashMap<String, BEValue>();
            Long sourceSize = hashingResult.getSourceSizes().get(i);
            String fullPath = this.filesPaths.get(i);
            ArrayList<BEValue> filePath = new ArrayList<BEValue>();
            for (String path : fullPath.replace("\\", "/").split("/")) {
                filePath.add(new BEValue(path));
            }
            file.put("path", new BEValue(filePath));
            file.put("length", new BEValue(sourceSize));
            result.add(new BEValue(file));
        }
        return result;
    }

    private BEValue concatHashes(List<byte[]> hashes) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (byte[] hash : hashes) {
            sb.append(new String(hash, "ISO-8859-1"));
        }
        return new BEValue(sb.toString(), "ISO-8859-1");
    }

    private BEValue wrapStringList(List<String> lst) throws UnsupportedEncodingException {
        LinkedList<BEValue> result = new LinkedList<BEValue>();
        for (String s : lst) {
            result.add(new BEValue(s));
        }
        return new BEValue(result);
    }

    private BEValue wrapAnnounceList() throws UnsupportedEncodingException {
        LinkedList<BEValue> result = new LinkedList<BEValue>();
        for (List<String> tier : this.announceList) {
            result.add(this.wrapStringList(tier));
        }
        return new BEValue(result);
    }

    private void dropEmptyTiersFromAnnounce() {
        Iterator<List<String>> iterator = this.announceList.iterator();
        while (iterator.hasNext()) {
            List<String> tier = iterator.next();
            if (!tier.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void closeAllSources() {
        for (DataSourceHolder sourceHolder : this.dataSources) {
            try {
                sourceHolder.close();
            }
            catch (Throwable e) {
                logger.error("Error in closing data source " + sourceHolder, e);
            }
        }
    }

    private void initFirstTier() {
        if (this.announceList.isEmpty()) {
            this.newTier();
        }
    }

    private static class StreamBasedHolderImpl
    implements DataSourceHolder {
        private final InputStream source;
        private final boolean closeAfterBuild;

        public StreamBasedHolderImpl(InputStream source, boolean closeAfterBuild) {
            this.source = source;
            this.closeAfterBuild = closeAfterBuild;
        }

        @Override
        public InputStream getStream() {
            return this.source;
        }

        @Override
        public void close() throws IOException {
            if (this.closeAfterBuild) {
                this.source.close();
            }
        }

        public String toString() {
            return "Data source for user's stream " + this.source;
        }
    }

    private static class FileSourceHolder
    implements DataSourceHolder {
        @Nullable
        private FileInputStream fis;
        @NotNull
        private final File source;

        public FileSourceHolder(@NotNull File source) {
            this.source = source;
        }

        @Override
        public InputStream getStream() throws IOException {
            if (this.fis == null) {
                this.fis = new FileInputStream(this.source);
            }
            return this.fis;
        }

        @Override
        public void close() throws IOException {
            if (this.fis != null) {
                this.fis.close();
            }
        }

        public String toString() {
            return "Data source for file stream " + this.fis;
        }
    }
}

