/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol;

import java.nio.ByteBuffer;

public abstract class TrackerMessage {
    private final Type type;
    private final ByteBuffer data;

    protected TrackerMessage(Type type, ByteBuffer data) {
        this.type = type;
        this.data = data;
        if (this.data != null) {
            this.data.rewind();
        }
    }

    public Type getType() {
        return this.type;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public static enum Type {
        UNKNOWN(-1),
        CONNECT_REQUEST(0),
        CONNECT_RESPONSE(0),
        ANNOUNCE_REQUEST(1),
        ANNOUNCE_RESPONSE(1),
        SCRAPE_REQUEST(2),
        SCRAPE_RESPONSE(2),
        ERROR(3);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static interface ErrorMessage {
        public String getReason();

        public static enum FailureReason {
            UNKNOWN_TORRENT("The requested torrent does not exist on this tracker"),
            MISSING_HASH("Missing info hash"),
            MISSING_PEER_ID("Missing peer ID"),
            MISSING_PORT("Missing port"),
            INVALID_EVENT("Unexpected event for peer state"),
            NOT_IMPLEMENTED("Feature not implemented");

            private String message;

            private FailureReason(String message) {
                this.message = message;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }

    public static interface ConnectionResponseMessage {
    }

    public static interface ConnectionRequestMessage {
    }

    public static class MessageValidationException
    extends Exception {
        static final long serialVersionUID = -1L;

        public MessageValidationException(String s) {
            super(s);
        }

        public MessageValidationException(String s, Throwable cause) {
            super(s, cause);
        }
    }
}

